/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.tags;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.MetalItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;

public class BlockTagProvider
extends BlockTagsProvider {
    public BlockTagProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "tconstruct", existingFileHelper);
    }

    protected void m_6577_() {
        this.addCommon();
        this.addTools();
        this.addWorld();
        this.addSmeltery();
        this.addFluids();
        this.addHarvest();
    }

    private void addCommon() {
        this.addMetalTags(TinkerMaterials.cobalt, true);
        this.addMetalTags(TinkerMaterials.slimesteel, false);
        this.addMetalTags(TinkerMaterials.amethystBronze, false);
        this.addMetalTags(TinkerMaterials.roseGold, false);
        this.addMetalTags(TinkerMaterials.pigIron, false);
        this.addMetalTags(TinkerMaterials.queensSlime, true);
        this.addMetalTags(TinkerMaterials.manyullyn, true);
        this.addMetalTags(TinkerMaterials.hepatizon, true);
        this.addMetalTags(TinkerMaterials.soulsteel, true);
        this.addMetalTags(TinkerMaterials.knightslime, false);
        TagsProvider.TagAppender silicaPanes = this.m_206424_(TinkerTags.Blocks.GLASS_PANES_SILICA);
        silicaPanes.m_126584_((Object[])new Block[]{Blocks.f_50185_, (Block)TinkerCommons.clearGlassPane.get(), Blocks.f_50371_, Blocks.f_50367_, Blocks.f_50368_, Blocks.f_50365_, Blocks.f_50363_, Blocks.f_50369_, Blocks.f_50306_, Blocks.f_50364_, Blocks.f_50361_, Blocks.f_50305_, Blocks.f_50304_, Blocks.f_50362_, Blocks.f_50366_, Blocks.f_50370_, Blocks.f_50303_, Blocks.f_50307_});
        this.m_206424_(Tags.Blocks.GLASS_COLORLESS).m_126582_((Object)((Block)TinkerCommons.clearGlass.get()));
        this.m_206424_(Tags.Blocks.GLASS_PANES_COLORLESS).m_126582_((Object)((Block)TinkerCommons.clearGlassPane.get()));
        this.addGlass(TinkerCommons.clearStainedGlass, "glass/", (TagsProvider.TagAppender<Block>)this.m_206424_(Tags.Blocks.STAINED_GLASS));
        this.addGlass(TinkerCommons.clearStainedGlassPane, "glass_panes/", (TagsProvider.TagAppender<Block>)this.m_206424_(Tags.Blocks.STAINED_GLASS_PANES));
        TinkerCommons.clearStainedGlassPane.forEach(pane -> silicaPanes.m_126582_((Object)pane));
        TagsProvider.TagAppender impermeable = this.m_206424_(BlockTags.f_13049_);
        TagsProvider.TagAppender silicaGlass = this.m_206424_(Tags.Blocks.GLASS_SILICA);
        impermeable.m_126584_((Object[])new Block[]{(Block)TinkerCommons.clearGlass.get(), (Block)TinkerCommons.soulGlass.get(), (Block)TinkerCommons.clearTintedGlass.get(), (Block)TinkerSmeltery.searedGlass.get(), (Block)TinkerSmeltery.searedSoulGlass.get(), (Block)TinkerSmeltery.searedTintedGlass.get(), (Block)TinkerSmeltery.scorchedGlass.get(), (Block)TinkerSmeltery.scorchedSoulGlass.get(), (Block)TinkerSmeltery.scorchedTintedGlass.get()});
        silicaGlass.m_126582_((Object)((Block)TinkerCommons.clearGlass.get()));
        TinkerCommons.clearStainedGlass.values().forEach(arg_0 -> ((TagsProvider.TagAppender)impermeable).m_126582_(arg_0));
        TinkerCommons.clearStainedGlass.values().forEach(arg_0 -> ((TagsProvider.TagAppender)silicaGlass).m_126582_(arg_0));
        this.m_206424_(Tags.Blocks.GLASS_TINTED).m_126582_((Object)((Block)TinkerCommons.clearTintedGlass.get()));
        this.m_206424_(BlockTags.f_13080_).m_126584_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get(), (Block)TinkerCommons.soulGlassPane.get(), (Block)TinkerSmeltery.searedSoulGlass.get(), (Block)TinkerSmeltery.searedSoulGlassPane.get(), (Block)TinkerSmeltery.scorchedSoulGlass.get(), (Block)TinkerSmeltery.scorchedSoulGlassPane.get()});
        this.m_206424_(BlockTags.f_13085_).m_126584_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get(), (Block)TinkerSmeltery.searedSoulGlass.get(), (Block)TinkerSmeltery.scorchedSoulGlass.get()});
        this.m_206424_(TinkerTags.Blocks.TRANSPARENT_OVERLAY).m_126584_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get(), (Block)TinkerCommons.soulGlassPane.get(), (Block)TinkerSmeltery.searedSoulGlass.get(), (Block)TinkerSmeltery.searedSoulGlassPane.get(), (Block)TinkerSmeltery.scorchedSoulGlass.get(), (Block)TinkerSmeltery.scorchedSoulGlassPane.get()});
        this.m_206424_(TinkerTags.Blocks.WORKSTATION_ROCK).addTags(new TagKey[]{TinkerTags.Blocks.STONE, TinkerTags.Blocks.BLACKSTONE, TinkerTags.Blocks.GRANITE, TinkerTags.Blocks.DIORITE, TinkerTags.Blocks.ANDESITE, TinkerTags.Blocks.DEEPSLATE, TinkerTags.Blocks.BASALT});
        TagsProvider.TagAppender builder = this.m_206424_(TinkerTags.Blocks.ANVIL_METAL).m_206428_(TinkerMaterials.slimesteel.getBlockTag()).m_206428_(TinkerMaterials.amethystBronze.getBlockTag()).m_206428_(TinkerMaterials.roseGold.getBlockTag()).m_206428_(TinkerMaterials.pigIron.getBlockTag()).m_206428_(TinkerMaterials.queensSlime.getBlockTag()).m_206428_(TinkerMaterials.manyullyn.getBlockTag()).m_206428_(TinkerMaterials.hepatizon.getBlockTag()).m_206428_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE);
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (compat.isOre()) continue;
            builder.m_176841_(new ResourceLocation("forge", "storage_blocks/" + compat.getName()));
        }
        this.m_206424_(TinkerTags.Blocks.PLANKLIKE).m_206428_(BlockTags.f_13090_).m_126584_((Object[])new Block[]{(Block)TinkerMaterials.blazewood.get(), (Block)TinkerMaterials.nahuatl.get()});
        this.m_206424_(TinkerTags.Blocks.PLATFORM_CONNECTIONS).m_126584_((Object[])new Block[]{Blocks.f_50164_, Blocks.f_50155_, Blocks.f_50183_, (Block)TinkerCommons.goldBars.get(), Blocks.f_50266_, Blocks.f_50082_, Blocks.f_50140_, Blocks.f_50123_, Blocks.f_50088_}).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES, BlockTags.f_13093_, Tags.Blocks.FENCES, BlockTags.f_13032_, BlockTags.f_13067_});
        TagsProvider.TagAppender copperPlatforms = this.m_206424_(TinkerTags.Blocks.COPPER_PLATFORMS);
        TinkerCommons.copperPlatform.forEach(block -> copperPlatforms.m_126582_((Object)block));
        TinkerCommons.waxedCopperPlatform.forEach(block -> copperPlatforms.m_126582_((Object)block));
    }

    private void addTools() {
        this.m_206424_(TinkerTags.Blocks.WORKBENCHES).m_126584_((Object[])new Block[]{Blocks.f_50091_, (Block)TinkerTables.craftingStation.get()}).m_176841_(new ResourceLocation("forge:workbench"));
        this.m_206424_(TinkerTags.Blocks.TABLES).m_126584_((Object[])new Block[]{(Block)TinkerTables.craftingStation.get(), (Block)TinkerTables.partBuilder.get(), (Block)TinkerTables.tinkerStation.get()});
        this.m_206424_(TinkerTags.Blocks.HARVESTABLE_STACKABLE).m_126584_((Object[])new Block[]{Blocks.f_50130_, Blocks.f_50576_});
        this.m_206424_(TinkerTags.Blocks.HARVESTABLE_CROPS).m_206428_(BlockTags.f_13073_).m_176841_(new ResourceLocation("forge", "crops")).m_126582_((Object)Blocks.f_50200_);
        this.m_206424_(TinkerTags.Blocks.HARVESTABLE_INTERACT).m_126582_((Object)Blocks.f_50685_);
        this.m_206424_(TinkerTags.Blocks.HARVESTABLE).m_126584_((Object[])new Block[]{Blocks.f_50133_, Blocks.f_50718_, Blocks.f_50717_}).m_206428_(TinkerTags.Blocks.HARVESTABLE_CROPS).m_206428_(TinkerTags.Blocks.HARVESTABLE_INTERACT).m_206428_(TinkerTags.Blocks.HARVESTABLE_STACKABLE);
        this.m_206424_(TinkerTags.Blocks.TREE_LOGS).m_206428_(BlockTags.f_13106_);
        this.m_206424_(TinkerTags.Blocks.CHRYSOPHILITE_ORES).m_206428_(Tags.Blocks.ORES_GOLD).m_126582_((Object)Blocks.f_50706_);
    }

    private void addWorld() {
        this.m_206424_(TinkerTags.Blocks.ORES_COBALT).m_126582_((Object)((Block)TinkerWorld.cobaltOre.get()));
        this.m_206424_(Tags.Blocks.ORES).m_206428_(TinkerTags.Blocks.ORES_COBALT);
        this.m_206424_(Tags.Blocks.ORES_IN_GROUND_NETHERRACK).m_126582_((Object)((Block)TinkerWorld.cobaltOre.get()));
        this.m_206424_(Tags.Blocks.ORE_RATES_SINGULAR).m_126582_((Object)((Block)TinkerWorld.cobaltOre.get()));
        this.m_206424_(TinkerTags.Blocks.RAW_BLOCK_COBALT).m_126582_((Object)((Block)TinkerWorld.rawCobaltBlock.get()));
        this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).m_206428_(TinkerTags.Blocks.RAW_BLOCK_COBALT);
        TagsProvider.TagAppender endermanHoldable = this.m_206424_(BlockTags.f_13046_);
        endermanHoldable.m_206428_(TinkerTags.Blocks.CONGEALED_SLIME).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.grout.get(), (Block)TinkerSmeltery.netherGrout.get()});
        this.m_206424_(TinkerTags.Blocks.SLIMY_LOGS).addTags(new TagKey[]{TinkerWorld.greenheart.getLogBlockTag(), TinkerWorld.skyroot.getLogBlockTag(), TinkerWorld.bloodshroom.getLogBlockTag(), TinkerWorld.enderbark.getLogBlockTag()});
        this.m_206424_(TinkerTags.Blocks.SLIMY_PLANKS).m_126584_((Object[])new Block[]{(Block)TinkerWorld.greenheart.get(), (Block)TinkerWorld.skyroot.get(), (Block)TinkerWorld.bloodshroom.get(), (Block)TinkerWorld.enderbark.get()});
        this.m_206424_(BlockTags.f_13090_).m_206428_(TinkerTags.Blocks.SLIMY_PLANKS);
        this.m_206424_(BlockTags.f_13106_).m_206428_(TinkerTags.Blocks.SLIMY_LOGS);
        this.addWoodTags(TinkerWorld.greenheart, false);
        this.addWoodTags(TinkerWorld.skyroot, false);
        this.addWoodTags(TinkerWorld.bloodshroom, false);
        this.addWoodTags(TinkerWorld.enderbark, false);
        TagsProvider.TagAppender slimeBlockTagAppender = this.m_206424_(TinkerTags.Blocks.SLIME_BLOCK);
        TagsProvider.TagAppender congealedTagAppender = this.m_206424_(TinkerTags.Blocks.CONGEALED_SLIME);
        for (SlimeType slimeType : SlimeType.values()) {
            slimeBlockTagAppender.m_126582_((Object)((Block)TinkerWorld.slime.get((Enum)slimeType)));
            congealedTagAppender.m_126582_((Object)((Block)TinkerWorld.congealedSlime.get((Enum)slimeType)));
        }
        this.m_206424_(TinkerTags.Blocks.SLIMY_VINES).m_126584_((Object[])new Block[]{(Block)TinkerWorld.skySlimeVine.get(), (Block)TinkerWorld.enderSlimeVine.get()});
        TagsProvider.TagAppender leavesTagAppender = this.m_206424_(TinkerTags.Blocks.SLIMY_LEAVES);
        TagsProvider.TagAppender wartTagAppender = this.m_206424_(BlockTags.f_13078_);
        TagsProvider.TagAppender saplingTagAppender = this.m_206424_(TinkerTags.Blocks.SLIMY_SAPLINGS);
        for (FoliageType foliageType : FoliageType.values()) {
            if (foliageType.isNether()) {
                wartTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeLeaves.get((Enum)foliageType)));
                endermanHoldable.m_126582_((Object)((Block)TinkerWorld.slimeSapling.get((Enum)foliageType)));
                continue;
            }
            leavesTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeLeaves.get((Enum)foliageType)));
            saplingTagAppender.m_126582_((Object)((Block)TinkerWorld.slimeSapling.get((Enum)foliageType)));
        }
        this.m_206424_(BlockTags.f_13035_).m_206428_(TinkerTags.Blocks.SLIMY_LEAVES);
        this.m_206424_(BlockTags.f_13104_).m_206428_(TinkerTags.Blocks.SLIMY_SAPLINGS);
        TagsProvider.TagAppender tagAppender = this.m_206424_(TinkerTags.Blocks.SLIMY_GRASS);
        TagsProvider.TagAppender slimyNylium = this.m_206424_(TinkerTags.Blocks.SLIMY_NYLIUM);
        TagsProvider.TagAppender slimySoil = this.m_206424_(TinkerTags.Blocks.SLIMY_SOIL);
        for (FoliageType foliageType : FoliageType.values()) {
            (foliageType.isNether() ? slimyNylium : tagAppender).m_206428_(foliageType.getGrassBlockTag());
        }
        for (DirtType dirtType2 : DirtType.values()) {
            slimySoil.m_206428_(dirtType2.getBlockTag());
        }
        TinkerWorld.slimeGrass.forEach((dirtType, blockObj) -> blockObj.forEach((grassType, block) -> {
            this.m_206424_(grassType.getGrassBlockTag()).m_126582_(block);
            this.m_206424_(dirtType.getBlockTag()).m_126582_(block);
        }));
        TinkerWorld.slimeDirt.forEach((type, block) -> this.m_206424_(type.getBlockTag()).m_126582_(block));
        TagsProvider.TagAppender tagAppender2 = this.m_206424_(TinkerTags.Blocks.ENDERBARK_ROOTS).m_126582_((Object)((Block)TinkerWorld.enderbarkRoots.get()));
        TinkerWorld.slimyEnderbarkRoots.forEach((type, block) -> {
            this.m_206424_(type.getDirtType().getBlockTag()).m_126582_(block);
            enderBarkRoots.m_126582_(block);
        });
        endermanHoldable.m_206428_(TinkerTags.Blocks.SLIMY_SOIL);
        this.tagBlocks((TagKey<Block>)BlockTags.f_198158_, TinkerWorld.slimeTallGrass, TinkerWorld.slimeFern);
        Consumer<Block> flowerPotAppender = arg_0 -> ((TagsProvider.TagAppender)this.m_206424_(BlockTags.f_13045_)).m_126582_(arg_0);
        TinkerWorld.pottedSlimeFern.forEach(flowerPotAppender);
        TinkerWorld.pottedSlimeSapling.forEach(flowerPotAppender);
        this.m_206424_(TinkerTags.Blocks.ENDERBARK_LOGS_CAN_GROW_THROUGH).addTags(new TagKey[]{TinkerTags.Blocks.SLIMY_VINES, TinkerTags.Blocks.SLIMY_SAPLINGS, TinkerTags.Blocks.CONGEALED_SLIME, TinkerTags.Blocks.ENDERBARK_ROOTS, TinkerTags.Blocks.SLIMY_LEAVES, TinkerTags.Blocks.SLIMY_LOGS});
        this.m_206424_(TinkerTags.Blocks.ENDERBARK_ROOTS_CAN_GROW_THROUGH).addTags(new TagKey[]{TinkerTags.Blocks.SLIMY_VINES, TinkerTags.Blocks.SLIMY_SAPLINGS, TinkerTags.Blocks.CONGEALED_SLIME, TinkerTags.Blocks.ENDERBARK_ROOTS}).m_126582_((Object)Blocks.f_50125_);
        this.m_206424_(TinkerTags.Blocks.SKY_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.earthGeode.getBlock(), TinkerWorld.earthGeode.getBudding()}).m_206428_(FoliageType.SKY.getGrassBlockTag());
        this.m_206424_(TinkerTags.Blocks.EARTH_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.skyGeode.getBlock(), TinkerWorld.skyGeode.getBudding()}).m_206428_(FoliageType.EARTH.getGrassBlockTag());
        this.m_206424_(TinkerTags.Blocks.ENDER_SLIME_SPAWN).m_126584_((Object[])new Block[]{TinkerWorld.enderGeode.getBlock(), TinkerWorld.enderGeode.getBudding()}).m_206428_(FoliageType.ENDER.getGrassBlockTag());
        this.m_206424_(BlockTags.f_13088_).m_126584_((Object[])new Block[]{(Block)TinkerTables.castChest.get(), (Block)TinkerCommons.goldBars.get(), (Block)TinkerCommons.goldPlatform.get(), (Block)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN), (Block)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN_BRUTE), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.PIGLIN_BRUTE)});
        this.m_206424_(BlockTags.f_13042_).m_126584_((Object[])new Block[]{(Block)TinkerWorld.heads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN), (Block)TinkerWorld.wallHeads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN)});
        this.m_206424_(TinkerTags.Blocks.STONE).m_126584_((Object[])new Block[]{Blocks.f_50069_, Blocks.f_50652_, Blocks.f_50079_});
        this.m_206424_(TinkerTags.Blocks.GRANITE).m_126582_((Object)Blocks.f_50122_);
        this.m_206424_(TinkerTags.Blocks.DIORITE).m_126582_((Object)Blocks.f_50228_);
        this.m_206424_(TinkerTags.Blocks.ANDESITE).m_126582_((Object)Blocks.f_50334_);
        this.m_206424_(TinkerTags.Blocks.BLACKSTONE).m_126582_((Object)Blocks.f_50730_);
        this.m_206424_(TinkerTags.Blocks.DEEPSLATE).m_126584_((Object[])new Block[]{Blocks.f_152550_, Blocks.f_152551_});
        this.m_206424_(TinkerTags.Blocks.BASALT).m_126582_((Object)Blocks.f_50137_);
    }

    private void addSmeltery() {
        this.m_206424_(TinkerTags.Blocks.SEARED_BRICKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedBricks.get(), (Block)TinkerSmeltery.searedFancyBricks.get(), (Block)TinkerSmeltery.searedTriangleBricks.get()});
        this.m_206424_(TinkerTags.Blocks.SEARED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedStone.get(), (Block)TinkerSmeltery.searedCrackedBricks.get(), (Block)TinkerSmeltery.searedCobble.get(), (Block)TinkerSmeltery.searedPaver.get()}).m_206428_(TinkerTags.Blocks.SEARED_BRICKS);
        this.m_206424_(TinkerTags.Blocks.SMELTERY_BRICKS).m_206428_(TinkerTags.Blocks.SEARED_BLOCKS);
        this.m_206424_(BlockTags.f_13032_).m_126584_((Object[])new Block[]{TinkerSmeltery.searedBricks.getWall(), TinkerSmeltery.searedCobble.getWall()});
        this.m_206424_(TinkerTags.Blocks.SCORCHED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedStone.get(), (Block)TinkerSmeltery.polishedScorchedStone.get(), (Block)TinkerSmeltery.scorchedBricks.get(), (Block)TinkerSmeltery.scorchedRoad.get(), (Block)TinkerSmeltery.chiseledScorchedBricks.get()});
        this.m_206424_(TinkerTags.Blocks.FOUNDRY_BRICKS).m_206428_(TinkerTags.Blocks.SCORCHED_BLOCKS);
        this.m_206424_(BlockTags.f_13039_).m_126584_((Object[])new Block[]{TinkerSmeltery.scorchedBricks.getFence(), TinkerMaterials.blazewood.getFence(), TinkerMaterials.nahuatl.getFence()});
        this.m_206424_(TinkerTags.Blocks.CISTERN_CONNECTIONS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedFaucet.get(), (Block)TinkerSmeltery.scorchedFaucet.get()});
        TagsProvider.TagAppender searedTankTagAppender = this.m_206424_(TinkerTags.Blocks.SEARED_TANKS);
        TinkerSmeltery.searedTank.values().forEach(arg_0 -> ((TagsProvider.TagAppender)searedTankTagAppender).m_126582_(arg_0));
        TagsProvider.TagAppender scorchedTankTagAppender = this.m_206424_(TinkerTags.Blocks.SCORCHED_TANKS);
        TinkerSmeltery.scorchedTank.values().forEach(arg_0 -> ((TagsProvider.TagAppender)scorchedTankTagAppender).m_126582_(arg_0));
        this.m_206424_(TinkerTags.Blocks.HEATER_CONTROLLERS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedMelter.get(), (Block)TinkerSmeltery.scorchedAlloyer.get()});
        this.m_206424_(TinkerTags.Blocks.FUEL_TANKS).m_126582_((Object)((Block)TinkerSmeltery.searedHeater.get())).m_206428_(TinkerTags.Blocks.SEARED_TANKS).m_206428_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_206424_(TinkerTags.Blocks.SMELTERY_TANKS).m_206428_(TinkerTags.Blocks.SEARED_TANKS);
        this.m_206424_(TinkerTags.Blocks.FOUNDRY_TANKS).m_206428_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_206424_(TinkerTags.Blocks.ALLOYER_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedAlloyer.get(), (Block)TinkerSmeltery.searedMelter.get()}).m_206428_(TinkerTags.Blocks.SEARED_TANKS).m_206428_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.m_206424_(TinkerTags.Blocks.SMELTERY_FLOOR).m_206428_(TinkerTags.Blocks.SEARED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.m_206424_(TinkerTags.Blocks.SMELTERY_WALL).m_206428_(TinkerTags.Blocks.SEARED_BLOCKS).m_206428_(TinkerTags.Blocks.SMELTERY_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedGlass.get(), (Block)TinkerSmeltery.searedSoulGlass.get(), (Block)TinkerSmeltery.searedTintedGlass.get(), (Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.m_206424_(TinkerTags.Blocks.SMELTERY).m_206428_(TinkerTags.Blocks.SMELTERY_WALL).m_206428_(TinkerTags.Blocks.SMELTERY_FLOOR).m_206428_(TinkerTags.Blocks.SMELTERY_TANKS);
        this.m_206424_(TinkerTags.Blocks.FOUNDRY_FLOOR).m_206428_(TinkerTags.Blocks.SCORCHED_BLOCKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.m_206424_(TinkerTags.Blocks.FOUNDRY_WALL).m_206428_(TinkerTags.Blocks.SCORCHED_BLOCKS).m_206428_(TinkerTags.Blocks.FOUNDRY_TANKS).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedGlass.get(), (Block)TinkerSmeltery.scorchedSoulGlass.get(), (Block)TinkerSmeltery.scorchedTintedGlass.get(), (Block)TinkerSmeltery.scorchedLadder.get(), (Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.m_206424_(TinkerTags.Blocks.FOUNDRY).m_206428_(TinkerTags.Blocks.FOUNDRY_WALL).m_206428_(TinkerTags.Blocks.FOUNDRY_FLOOR).m_206428_(TinkerTags.Blocks.FOUNDRY_TANKS);
        this.m_206424_(BlockTags.f_13082_).m_126584_((Object[])new Block[]{(Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.scorchedLadder.get()});
        this.m_206424_(BlockTags.f_13069_).m_126582_((Object)((Block)TinkerCommons.obsidianPane.get()));
    }

    private void addFluids() {
        this.m_206424_(BlockTags.f_13086_).m_126584_((Object[])new Block[]{TinkerFluids.magma.getBlock(), TinkerFluids.blazingBlood.getBlock()});
    }

    private void addHarvest() {
        this.tagBlocks((TagKey<Block>)BlockTags.f_144283_, new Supplier[]{TinkerCommons.cheeseBlock});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, new Supplier[]{TinkerGadgets.punji});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144284_, new Supplier[]{TinkerCommons.obsidianPane});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144286_, new Supplier[]{TinkerCommons.ironPlatform});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144285_, new Supplier[]{TinkerCommons.goldBars, TinkerCommons.goldPlatform, TinkerCommons.cobaltPlatform});
        this.m_206424_(BlockTags.f_144282_).m_206428_(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.m_206424_(BlockTags.f_144286_).m_206428_(TinkerTags.Blocks.COPPER_PLATFORMS);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)BlockTags.f_144285_, new BuildingBlockObject[]{TinkerMaterials.blazewood});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)BlockTags.f_144284_, new BuildingBlockObject[]{TinkerMaterials.nahuatl});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144285_, new Supplier[]{TinkerWorld.cobaltOre, TinkerWorld.rawCobaltBlock, TinkerMaterials.cobalt, TinkerMaterials.slimesteel, TinkerMaterials.amethystBronze, TinkerMaterials.roseGold, TinkerMaterials.pigIron});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144284_, new Supplier[]{TinkerMaterials.queensSlime, TinkerMaterials.manyullyn, TinkerMaterials.hepatizon, TinkerMaterials.soulsteel, TinkerModifiers.silkyJewelBlock});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_NETHERITE_TOOL, new Supplier[]{TinkerMaterials.knightslime});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144283_, TinkerWorld.congealedSlime, TinkerWorld.slimeDirt, TinkerWorld.vanillaSlimeGrass, TinkerWorld.earthSlimeGrass, TinkerWorld.skySlimeGrass, TinkerWorld.enderSlimeGrass, TinkerWorld.ichorSlimeGrass);
        TinkerWorld.slimeDirt.forEach((type, block) -> this.m_206424_(Objects.requireNonNull(type.getHarvestTier().getTag())).m_126582_(block));
        for (DirtType dirt : DirtType.values()) {
            for (FoliageType grass : FoliageType.values()) {
                Tiers dirtTier = dirt.getHarvestTier();
                Tiers grassTier = grass.getHarvestTier();
                Tiers tier = dirtTier.m_6604_() == grassTier.m_6604_() ? (dirtTier.ordinal() > grassTier.ordinal() ? dirtTier : grassTier) : (dirtTier.m_6604_() > grassTier.m_6604_() ? dirtTier : grassTier);
                this.m_206424_(Objects.requireNonNull(tier.getTag())).m_126582_((Object)((Block)TinkerWorld.slimeGrass.get((Object)dirt).get((Enum)grass)));
            }
        }
        this.tagBlocks((TagKey<Block>)BlockTags.f_144281_, TinkerWorld.slimeLeaves);
        this.tagLogs((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerWorld.skyroot);
        this.tagLogs((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)BlockTags.f_144286_, TinkerWorld.greenheart);
        this.tagLogs((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)BlockTags.f_144285_, TinkerWorld.bloodshroom);
        this.tagLogs((TagKey<Block>)BlockTags.f_144280_, (TagKey<Block>)BlockTags.f_144284_, TinkerWorld.enderbark);
        this.tagPlanks((TagKey<Block>)BlockTags.f_144283_, TinkerWorld.greenheart, TinkerWorld.skyroot, TinkerWorld.bloodshroom, TinkerWorld.enderbark);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144283_, TinkerWorld.slimyEnderbarkRoots);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, new Supplier[]{TinkerWorld.skySlimeVine, TinkerWorld.enderSlimeVine, TinkerWorld.enderbarkRoots});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, TinkerWorld.slimeTallGrass, TinkerWorld.slimeFern);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, TinkerWorld.earthGeode, TinkerWorld.skyGeode, TinkerWorld.ichorGeode, TinkerWorld.enderGeode);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144284_, new Supplier[]{TinkerWorld.enderbarkRoots});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144284_, TinkerWorld.slimyEnderbarkRoots);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144283_, new Supplier[]{TinkerSmeltery.grout, TinkerSmeltery.netherGrout});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.searedStone, TinkerSmeltery.searedPaver, TinkerSmeltery.searedCobble, TinkerSmeltery.searedBricks});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedCrackedBricks, TinkerSmeltery.searedFancyBricks, TinkerSmeltery.searedTriangleBricks, TinkerSmeltery.searedLadder, TinkerSmeltery.searedGlass, TinkerSmeltery.searedSoulGlass, TinkerSmeltery.searedTintedGlass, TinkerSmeltery.searedGlassPane, TinkerSmeltery.searedSoulGlassPane});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new BuildingBlockObject[]{TinkerSmeltery.scorchedBricks, TinkerSmeltery.scorchedRoad});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedStone, TinkerSmeltery.polishedScorchedStone, TinkerSmeltery.chiseledScorchedBricks, TinkerSmeltery.scorchedLadder, TinkerSmeltery.scorchedGlass, TinkerSmeltery.scorchedSoulGlass, TinkerSmeltery.scorchedTintedGlass, TinkerSmeltery.scorchedGlassPane, TinkerSmeltery.scorchedSoulGlassPane});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, TinkerSmeltery.searedTank, TinkerSmeltery.scorchedTank);
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedLantern, TinkerSmeltery.searedFaucet, TinkerSmeltery.searedChannel, TinkerSmeltery.searedBasin, TinkerSmeltery.searedTable});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.scorchedLantern, TinkerSmeltery.scorchedFaucet, TinkerSmeltery.scorchedChannel, TinkerSmeltery.scorchedBasin, TinkerSmeltery.scorchedTable});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)Tags.Blocks.NEEDS_GOLD_TOOL, new Supplier[]{TinkerSmeltery.searedHeater, TinkerSmeltery.searedMelter, TinkerSmeltery.scorchedAlloyer});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144286_, new Supplier[]{TinkerSmeltery.searedDrain, TinkerSmeltery.searedChute, TinkerSmeltery.smelteryController});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144285_, new Supplier[]{TinkerSmeltery.searedDuct, TinkerSmeltery.scorchedDuct});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144284_, new Supplier[]{TinkerSmeltery.scorchedDrain, TinkerSmeltery.scorchedChute, TinkerSmeltery.foundryController});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144280_, new Supplier[]{TinkerTables.craftingStation, TinkerTables.tinkerStation, TinkerTables.partBuilder, TinkerTables.tinkersChest, TinkerTables.partChest});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, new Supplier[]{TinkerTables.modifierWorktable});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144286_, new Supplier[]{TinkerTables.castChest});
        this.tagBlocks((TagKey<Block>)BlockTags.f_144282_, (TagKey<Block>)BlockTags.f_144285_, new Supplier[]{TinkerTables.tinkersAnvil, TinkerTables.scorchedAnvil});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_MATTOCK).addTags(new TagKey[]{BlockTags.f_144283_, BlockTags.f_13106_}).m_126584_((Object[])new Block[]{Blocks.f_152541_, Blocks.f_50571_, Blocks.f_152475_, Blocks.f_50191_, Blocks.f_50717_, Blocks.f_50718_, Blocks.f_50143_, Blocks.f_50144_, Blocks.f_50133_, Blocks.f_50491_, Blocks.f_50490_, Blocks.f_50262_, Blocks.f_50180_, Blocks.f_50182_, Blocks.f_50181_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_PICKADZE).addTags(new TagKey[]{BlockTags.f_144283_, BlockTags.f_144282_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_HAND_AXE).addTags(new TagKey[]{BlockTags.f_144280_, BlockTags.f_13035_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_SHEARS).m_126584_((Object[])new Block[]{Blocks.f_152541_, Blocks.f_50033_, Blocks.f_50577_, Blocks.f_152475_, Blocks.f_50196_, Blocks.f_50088_, Blocks.f_50267_, Blocks.f_50653_, Blocks.f_50704_, Blocks.f_50191_, Blocks.f_50703_, Blocks.f_50702_}).addTags(new TagKey[]{BlockTags.f_144275_, BlockTags.f_13035_, BlockTags.f_13089_, BlockTags.f_13104_, BlockTags.f_13041_, BlockTags.f_198158_, BlockTags.f_13063_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_SCYTHE).m_126584_((Object[])new Block[]{Blocks.f_50188_, Blocks.f_50187_, Blocks.f_152546_, Blocks.f_152545_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_50200_, Blocks.f_152547_, Blocks.f_152540_, Blocks.f_50130_, Blocks.f_50685_}).addTags(new TagKey[]{BlockTags.f_144281_, TinkerTags.Blocks.MINABLE_WITH_SHEARS, BlockTags.f_13073_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_SWORD).m_126582_((Object)Blocks.f_50033_).m_126584_((Object[])new Block[]{Blocks.f_50262_, Blocks.f_50490_, Blocks.f_50491_, Blocks.f_50685_, Blocks.f_50191_, Blocks.f_152543_, Blocks.f_152544_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152475_, Blocks.f_50133_, Blocks.f_50143_, Blocks.f_50186_}).addTags(new TagKey[]{BlockTags.f_13035_, BlockTags.f_13104_, BlockTags.f_13041_, BlockTags.f_13073_});
        this.m_206424_(TinkerTags.Blocks.MINABLE_WITH_DAGGER).addTags(new TagKey[]{BlockTags.f_144281_, TinkerTags.Blocks.MINABLE_WITH_SWORD});
        this.tagBlocks(TinkerTags.Blocks.MINEABLE_MELTING_BLACKLIST, new Supplier[]{TinkerSmeltery.searedMelter, TinkerSmeltery.smelteryController, TinkerSmeltery.foundryController, TinkerSmeltery.searedLantern, TinkerSmeltery.scorchedLantern});
        this.tagBlocks(TinkerTags.Blocks.MINEABLE_MELTING_BLACKLIST, TinkerSmeltery.searedTank, TinkerSmeltery.scorchedTank);
    }

    public String m_6055_() {
        return "Tinkers Construct Block Tags";
    }

    @SafeVarargs
    private void tagBlocks(TagKey<Block> tag, Supplier<? extends Block> ... blocks) {
        TagsProvider.TagAppender appender = this.m_206424_(tag);
        for (Supplier<? extends Block> block : blocks) {
            appender.m_126582_((Object)block.get());
        }
    }

    private void tagBlocks(TagKey<Block> tag, GeodeItemObject ... blocks) {
        TagsProvider.TagAppender appender = this.m_206424_(tag);
        for (GeodeItemObject geode : blocks) {
            appender.m_126582_((Object)geode.getBlock());
            appender.m_126582_((Object)geode.getBudding());
            for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.values()) {
                appender.m_126582_((Object)geode.getBud(size));
            }
        }
    }

    private void tagBlocks(TagKey<Block> tag1, TagKey<Block> tag2, Supplier<? extends Block> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    @SafeVarargs
    private void tagBlocks(TagKey<Block> tag, EnumObject<?, ? extends Block> ... blocks) {
        TagsProvider.TagAppender appender = this.m_206424_(tag);
        for (EnumObject<?, ? extends Block> block : blocks) {
            block.forEach(b -> appender.m_126582_(b));
        }
    }

    @SafeVarargs
    private void tagBlocks(TagKey<Block> tag1, TagKey<Block> tag2, EnumObject<?, ? extends Block> ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagBlocks(TagKey<Block> tag, BuildingBlockObject ... blocks) {
        TagsProvider.TagAppender appender = this.m_206424_(tag);
        for (BuildingBlockObject block : blocks) {
            block.values().forEach(arg_0 -> ((TagsProvider.TagAppender)appender).m_126582_(arg_0));
        }
    }

    private void tagBlocks(TagKey<Block> tag1, TagKey<Block> tag2, BuildingBlockObject ... blocks) {
        this.tagBlocks(tag1, blocks);
        this.tagBlocks(tag2, blocks);
    }

    private void tagLogs(TagKey<Block> tag1, TagKey<Block> tag2, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.m_206424_(tag1).m_126584_((Object[])new Block[]{block.getLog(), block.getWood()});
            this.m_206424_(tag2).m_126584_((Object[])new Block[]{block.getLog(), block.getWood()});
        }
    }

    private void tagPlanks(TagKey<Block> tag, WoodBlockObject ... blocks) {
        for (WoodBlockObject block : blocks) {
            this.m_206424_(tag).m_126584_((Object[])new Block[]{(Block)block.get(), block.getSlab(), block.getStairs(), block.getFence(), block.getStrippedLog(), block.getStrippedWood(), block.getFenceGate(), block.getDoor(), block.getTrapdoor(), block.getPressurePlate(), block.getButton(), block.getSign(), block.getWallSign()});
        }
    }

    private void addMetalTags(MetalItemObject metal, boolean beacon) {
        this.m_206424_(metal.getBlockTag()).m_126582_((Object)((Block)metal.get()));
        if (beacon) {
            this.m_206424_(BlockTags.f_13079_).m_206428_(metal.getBlockTag());
        }
        this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).m_206428_(metal.getBlockTag());
    }

    private void addGlass(EnumObject<ClearStainedGlassBlock.GlassColor, ? extends Block> blockObj, String tagPrefix, TagsProvider.TagAppender<Block> blockTag) {
        blockObj.forEach((color, block) -> {
            blockTag.m_126582_(block);
            this.m_206424_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("forge", tagPrefix + color.m_7912_()))).m_126582_(block);
        });
    }

    private void addWoodTags(WoodBlockObject object, boolean doesBurn) {
        this.m_206424_(BlockTags.f_13097_).m_126582_((Object)object.getSlab());
        this.m_206424_(BlockTags.f_13096_).m_126582_((Object)object.getStairs());
        this.m_206424_(object.getLogBlockTag()).m_126584_((Object[])new Block[]{object.getLog(), object.getStrippedLog(), object.getWood(), object.getStrippedWood()});
        this.m_206424_(BlockTags.f_13098_).m_126582_((Object)object.getFence());
        this.m_206424_(Tags.Blocks.FENCES_WOODEN).m_126582_((Object)object.getFence());
        this.m_206424_(BlockTags.f_13055_).m_126582_((Object)object.getFenceGate());
        this.m_206424_(Tags.Blocks.FENCE_GATES_WOODEN).m_126582_((Object)object.getFenceGate());
        this.m_206424_(BlockTags.f_13095_).m_126582_((Object)object.getDoor());
        this.m_206424_(BlockTags.f_13102_).m_126582_((Object)object.getTrapdoor());
        this.m_206424_(BlockTags.f_13092_).m_126582_((Object)object.getButton());
        this.m_206424_(BlockTags.f_13100_).m_126582_((Object)object.getPressurePlate());
        if (doesBurn) {
            this.m_206424_(BlockTags.f_13105_).m_206428_(object.getLogBlockTag());
        } else {
            this.m_206424_(BlockTags.f_13044_).m_126584_((Object[])new Block[]{(Block)object.get(), object.getSlab(), object.getStairs(), object.getFence(), object.getFenceGate(), object.getDoor(), object.getTrapdoor(), object.getPressurePlate(), object.getButton()}).m_206428_(object.getLogBlockTag());
        }
        this.m_206424_(BlockTags.f_13066_).m_126582_((Object)object.getSign());
        this.m_206424_(BlockTags.f_13067_).m_126582_((Object)object.getWallSign());
    }
}

