/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MagicProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> MAGIC_DATA = TConstruct.createKey("magic_protection", ModifierMaxLevel::new);

    public MagicProtectionModifier() {
        super(MAGIC_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, MobEffectEvent.Added.class, MagicProtectionModifier::onPotionStart);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule((HookProvider)ProtectionModule.builder().sources(new IJsonPredicate[]{DamageSourcePredicate.CAN_PROTECT, DamageSourcePredicate.MAGIC}).eachLevel(2.5f));
    }

    private static void onPotionStart(MobEffectEvent.Added event) {
        MobEffectInstance newEffect = event.getEffectInstance();
        if (!newEffect.m_19544_().m_19486_() && !newEffect.getCurativeItems().isEmpty()) {
            LivingEntity living = event.getEntity();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float max;
                ModifierMaxLevel magicData = data.get(MAGIC_DATA);
                if (magicData != null && (max = magicData.getMax()) > 0.0f) {
                    int duration = (int)((float)newEffect.m_19557_() * (1.0f - max * 0.05f));
                    if (duration < 0) {
                        duration = 0;
                    }
                    newEffect.f_19503_ = duration;
                }
            });
        }
    }
}

