/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.armor.EffectImmunityModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.modules.ranged.RestrictAngleModule;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEvents {
    private static final String SOULBOUND_SLOT = "tic_soulbound_slot";
    private static final TinkerDataCapability.TinkerDataKey<Float> PROJECTILE_EXPERIENCE = TConstruct.createKey("projectile_experience");
    public static final ResourceLocation SOULBOUND = TConstruct.getResource("soulbound");

    @SubscribeEvent
    static void onKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            int crystalbound;
            float knockback = data.get(TinkerDataKeys.KNOCKBACK, Float.valueOf(0.0f)).floatValue();
            if (knockback != 0.0f) {
                event.setStrength(event.getStrength() * (1.0f + knockback));
            }
            if ((crystalbound = data.get(TinkerDataKeys.CRYSTALSTRIKE, 0).intValue()) > 0) {
                RestrictAngleModule.onKnockback(event, crystalbound);
            }
        });
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat(entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            event.setDistance(Math.max(event.getDistance() - boost, 0.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        float boost = ArmorStatModule.getStat(entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0f) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)boost * 0.1, 0.0));
        }
    }

    @SubscribeEvent
    static void isPotionApplicable(MobEffectEvent.Applicable event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            if (((Multiset)data.computeIfAbsent(EffectImmunityModule.EFFECT_IMMUNITY)).contains((Object)event.getEffectInstance().m_19544_())) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(PROJECTILE_EXPERIENCE, Float.valueOf(modifiers.getEntry(ModifierIds.experienced).getEffectiveLevel())));
        }
        LivingEntity entity2 = event.getEntity();
        if (!entity2.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && entity2 instanceof Player && !((player = (Player)entity2) instanceof FakePlayer)) {
            boolean soulBelt = ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SOUL_BELT) > 0;
            Inventory inventory = player.m_150109_();
            int hotbarSize = Inventory.m_36059_();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !soulBelt && !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
            int totalSize = inventory.m_6643_();
            for (int i = hotbarSize; i < totalSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
        }
    }

    private static int boost(int original, float bonus) {
        return (int)((float)original * (1.0f + bonus));
    }

    @SubscribeEvent
    static void beforeBlockBreak(BlockEvent.BreakEvent event) {
        float bonus = ArmorStatModule.getStat((LivingEntity)event.getPlayer(), TinkerDataKeys.EXPERIENCE);
        if (bonus != 0.0f) {
            event.setExpToDrop(ModifierEvents.boost(event.getExpToDrop(), bonus));
        }
    }

    @SubscribeEvent
    static void onExperienceDrop(LivingExperienceDropEvent event) {
        ToolStack tool;
        float boost;
        float projectileBoost;
        float armorBoost = 0.0f;
        Player player = event.getAttackingPlayer();
        if (player != null) {
            armorBoost = ArmorStatModule.getStat((LivingEntity)player, TinkerDataKeys.EXPERIENCE);
        }
        if ((projectileBoost = event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(PROJECTILE_EXPERIENCE)).orElse(Float.valueOf(-1.0f)).floatValue()) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), projectileBoost * 0.5f + armorBoost));
        } else if (projectileBoost != 0.0f && player != null && (boost = ((tool = Modifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player))) != null ? tool.getModifier(ModifierIds.experienced).getEffectiveLevel() : 0.0f) * 0.5f + armorBoost) > 0.0f) {
            event.setDroppedExperience(ModifierEvents.boost(event.getDroppedExperience(), boost));
        }
    }

    @SubscribeEvent
    static void onPlayerDropItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                Inventory inventory = player.m_150109_();
                ArrayList<ItemEntity> takenSlot = new ArrayList<ItemEntity>();
                while (iter.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
                    int slot = tag.m_128451_(SOULBOUND_SLOT);
                    if (inventory.m_8020_(slot).m_41619_()) {
                        inventory.m_6836_(slot, stack);
                    } else {
                        takenSlot.add(itemEntity);
                    }
                    iter.remove();
                }
                for (ItemEntity itemEntity : takenSlot) {
                    ItemStack stack = itemEntity.m_32055_();
                    if (inventory.m_36054_(stack)) continue;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SOULBOUND_SLOT);
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    drops.add(itemEntity);
                }
            }
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (clone.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        Inventory originalInv = original.m_150109_();
        Inventory cloneInv = clone.m_150109_();
        int size = Math.min(originalInv.m_6643_(), cloneInv.m_6643_());
        for (int i = 0; i < size; ++i) {
            CompoundTag tag;
            ItemStack stack = originalInv.m_8020_(i);
            if (stack.m_41619_() || (tag = stack.m_41783_()) == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
            cloneInv.m_6836_(i, stack);
            tag.m_128473_(SOULBOUND_SLOT);
            if (!tag.m_128456_()) continue;
            stack.m_41751_(null);
        }
    }
}

