/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.loot;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;

public record LootTableInjection(ResourceLocation name, List<LootPoolInjection> pools) {
    public static final RecordLoadable<LootTableInjection> LOADABLE = RecordLoadable.create((RecordField)Loadables.RESOURCE_LOCATION.requiredField("name", LootTableInjection::name), (RecordField)LootPoolInjection.LOADABLE.list(1).requiredField("pools", LootTableInjection::pools), LootTableInjection::new);

    public record LootPoolInjection(String name, LootPoolEntryContainer[] entries) {
        public static final RecordLoadable<LootPoolInjection> LOADABLE = RecordLoadable.create((RecordField)StringLoadable.DEFAULT.requiredField("name", LootPoolInjection::name), (RecordField)TinkerLoadables.LOOT_ENTRY.list(1).requiredField("entries", pool -> List.of(pool.entries)), LootPoolInjection::new);

        public LootPoolInjection(String name, List<LootPoolEntryContainer> entries) {
            this(name, entries.toArray(new LootPoolEntryContainer[0]));
        }

        public void inject(LootTable table) {
            LootPool pool = table.getPool(this.name);
            if (pool != null) {
                int oldLength = pool.f_79023_.length;
                pool.f_79023_ = Arrays.copyOf(pool.f_79023_, oldLength + this.entries.length);
                System.arraycopy(this.entries, 0, pool.f_79023_, oldLength, this.entries.length);
            } else {
                TConstruct.LOG.warn("Failed to inject loot into {} pool {}", (Object)table.getLootTableId(), (Object)this.name);
            }
        }
    }

    public static class Builder {
        private final Map<String, ImmutableList.Builder<LootPoolEntryContainer>> pools = new HashMap<String, ImmutableList.Builder<LootPoolEntryContainer>>();

        public Builder addToPool(String name, LootPoolEntryContainer ... entries) {
            this.pools.computeIfAbsent(name, n -> ImmutableList.builder()).add((Object[])entries);
            return this;
        }

        public Builder addToPool(LootPoolInjection injection) {
            return this.addToPool(injection.name, injection.entries);
        }

        public LootTableInjection build(ResourceLocation name) {
            return new LootTableInjection(name, this.pools.entrySet().stream().map(entry -> new LootPoolInjection((String)entry.getKey(), (List<LootPoolEntryContainer>)((ImmutableList.Builder)entry.getValue()).build())).toList());
        }
    }
}

