/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.mantle.util.IdExtender;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public abstract class AbstractToolItemModelProvider
extends GenericDataProvider {
    protected final Map<String, JsonObject> models = new HashMap<String, JsonObject>();
    protected final ExistingFileHelper existingFileHelper;
    protected final String modId;

    public AbstractToolItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper, String modId) {
        super(generator, PackType.CLIENT_RESOURCES, "models/item");
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
    }

    protected abstract void addModels() throws IOException;

    public void m_213708_(CachedOutput cache) throws IOException {
        this.addModels();
        this.models.forEach((location, object) -> this.saveJson(cache, new ResourceLocation(this.modId, location), object, null));
    }

    protected void tool(IdAwareObject tool, JsonObject properties, String ... brokenParts) throws IOException {
        ResourceLocation id = tool.getId();
        String name = id.m_135815_();
        this.withDisplay("tool/" + name + "/blocking", id, properties);
        this.transformTool("tool/" + name + "/broken", this.readJson(id), "", false, "broken", brokenParts);
    }

    protected void bow(IdAwareObject bow, JsonObject properties, boolean crossbow, String ... pullingParts) throws IOException {
        ResourceLocation id = bow.getId();
        String name = id.m_135815_();
        JsonObject base = this.readJson(id);
        base.remove("overrides");
        this.transformTool("tool/" + name + "/broken", base, "", false, "broken", "bowstring");
        this.withDisplay("tool/" + name + "/blocking", id, properties);
        if (crossbow) {
            String arrowName = "tool/" + name + "/arrow";
            String fireworkName = "tool/" + name + "/firework";
            JsonObject ammoBase = AbstractToolItemModelProvider.suffixTextures(base.deepCopy(), "3", pullingParts);
            this.models.put(arrowName, this.addPart(ammoBase.deepCopy(), "ammo", name, "arrow"));
            this.models.put(fireworkName, this.addPart(ammoBase.deepCopy(), "ammo", name, "firework"));
            this.withDisplay("tool/" + name + "/arrow_blocking", this.resource(arrowName), properties);
            this.withDisplay("tool/" + name + "/firework_blocking", this.resource(fireworkName), properties);
        } else {
            this.addPart(base, "arrow", name, "arrow");
        }
        for (int i = 1; i <= 3; ++i) {
            String pulling = "tool/" + name + "/pulling_" + i;
            this.transformTool(pulling, base, "", false, Integer.toString(i), pullingParts);
            this.withDisplay("tool/" + name + "/blocking_" + i, this.resource(pulling), properties);
        }
    }

    protected void staff(IdAwareObject staff, JsonObject properties) throws IOException {
        ResourceLocation id = staff.getId();
        String path = id.m_135815_();
        String name = path.substring(0, path.length() - "_staff".length());
        JsonObject base = this.readJson(id);
        this.withDisplay("tool/staff/" + name + "/blocking", id, properties);
        this.transformTool("tool/staff/" + name + "/broken", base, "", true, "broken", "tool");
        for (int i = 1; i <= 5; ++i) {
            String charging = "tool/staff/" + name + "/charging_" + i;
            this.transformTool(charging, base, "tconstruct:item/base/staff_charging", false, Integer.toString(i), "tool");
            this.withDisplay("tool/staff/" + name + "/blocking_" + i, this.resource(charging), properties);
        }
    }

    protected void shield(String setName, IdAwareObject shield, JsonObject properties, String ... parts) throws IOException {
        ResourceLocation id = shield.getId();
        this.withDisplay("armor/" + setName + "/shield_blocking", id, Objects.requireNonNull(properties));
        this.transformTool("armor/" + setName + "/shield_broken", this.readJson(id), "", false, "broken", parts);
    }

    protected void armor(String name, EnumObject<ArmorSlotType, ? extends Item> armor, String ... textures) throws IOException {
        for (ArmorSlotType slot : ArmorSlotType.values()) {
            this.transformTool("armor/" + name + "/" + slot.m_7912_() + "_broken", this.readJson(Registry.f_122827_.m_7981_((Object)((Item)armor.get((Enum)slot)))), "", false, "broken", textures);
        }
    }

    protected JsonObject readJson(ResourceLocation path) throws IOException {
        try (BufferedReader reader = this.existingFileHelper.getResource(path, PackType.CLIENT_RESOURCES, ".json", "models/item").m_215508_();){
            JsonObject jsonObject = GsonHelper.m_13859_((Reader)reader);
            return jsonObject;
        }
    }

    protected ResourceLocation resource(String name) {
        return new ResourceLocation(this.modId, name);
    }

    protected void withDisplay(String destination, ResourceLocation parent, JsonObject properties) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", IdExtender.INSTANCE.prefix(parent, "item/").toString());
        model.add("display", properties.get("display"));
        this.models.put(destination, model);
    }

    protected static JsonArray copyAndSuffixRoot(JsonArray array, String suffix, boolean allRoots) {
        JsonArray newArray = new JsonArray();
        boolean first = true;
        for (JsonElement element : array) {
            if (allRoots || first) {
                newArray.add(element.getAsString() + suffix);
            }
            newArray.add(element);
            first = false;
        }
        return newArray;
    }

    protected JsonObject addPart(JsonObject tool, String part, String toolName, String texture) {
        JsonObject textures = tool.getAsJsonObject("textures");
        boolean large = GsonHelper.m_13855_((JsonObject)tool, (String)"large", (boolean)false);
        textures.addProperty(part, this.resource("item/tool/" + toolName + "/" + texture).toString());
        if (large) {
            textures.addProperty("large_" + part, this.resource("item/tool/" + toolName + "/large/" + texture).toString());
        }
        JsonObject partObject = new JsonObject();
        partObject.addProperty("name", part);
        tool.getAsJsonArray("parts").add((JsonElement)partObject);
        return tool;
    }

    protected static JsonObject suffixTextures(JsonObject tool, String suffix, String ... updateTextures) {
        boolean large = GsonHelper.m_13855_((JsonObject)tool, (String)"large", (boolean)false);
        JsonObject textures = tool.getAsJsonObject("textures");
        for (String part : updateTextures) {
            textures.addProperty(part, GsonHelper.m_13906_((JsonObject)textures, (String)part) + "_" + suffix);
            if (!large) continue;
            textures.addProperty("large_" + part, GsonHelper.m_13906_((JsonObject)textures, (String)("large_" + part)) + "_" + suffix);
        }
        return tool;
    }

    protected void transformTool(String destination, JsonObject tool, String parent, boolean allRoots, String suffix, String ... updateTextures) {
        JsonObject transformed = tool.deepCopy();
        if (!parent.isEmpty()) {
            transformed.addProperty("parent", parent);
        }
        AbstractToolItemModelProvider.suffixTextures(transformed, suffix, updateTextures);
        if (GsonHelper.m_13855_((JsonObject)transformed, (String)"large", (boolean)false)) {
            JsonObject roots = transformed.getAsJsonObject("modifier_roots");
            roots.add("small", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(roots.getAsJsonArray("small"), suffix + "/", allRoots));
            roots.add("large", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(roots.getAsJsonArray("large"), suffix + "/", allRoots));
        } else {
            transformed.add("modifier_roots", (JsonElement)AbstractToolItemModelProvider.copyAndSuffixRoot(transformed.getAsJsonArray("modifier_roots"), suffix + "/", allRoots));
        }
        transformed.remove("overrides");
        this.models.put(destination, transformed);
    }
}

