/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class ShulkingModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("shulking", ModifierMaxLevel::new);

    public ShulkingModifier() {
        super(KEY);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, ShulkingModifier::onAttack);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule((HookProvider)ProtectionModule.builder().sources(new IJsonPredicate[]{DamageSourcePredicate.CAN_PROTECT}).entity((IJsonPredicate<LivingEntity>)LivingEntityPredicate.CROUCHING).eachLevel(2.5f));
    }

    private static void onAttack(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker.m_6047_()) {
            attacker.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                ModifierMaxLevel max = data.get(KEY);
                if (max != null) {
                    event.setAmount(event.getAmount() * (1.0f - max.getMax() * 0.1f));
                }
            });
        }
    }
}

