/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class ProjectileProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final UUID ATTRIBUTE_UUID = UUID.fromString("6f030b1e-e9e1-11ec-8fea-0242ac120002");
    private static final TinkerDataCapability.ComputableDataKey<ModifierMaxLevel> PROJECTILE_DATA = TConstruct.createKey("projectile_protection", ModifierMaxLevel::new);

    public ProjectileProtectionModifier() {
        super(PROJECTILE_DATA, true);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule((HookProvider)ProtectionModule.builder().sources(new IJsonPredicate[]{DamageSourcePredicate.CAN_PROTECT, DamageSourcePredicate.PROJECTILE}).eachLevel(2.5f));
    }

    @Override
    protected void set(ModifierMaxLevel data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        AttributeInstance instance;
        float oldMax = data.getMax();
        super.set(data, slot, scaledLevel, context);
        float newMax = data.getMax();
        if (oldMax != newMax && (instance = context.getEntity().m_21051_(Attributes.f_22278_)) != null) {
            instance.m_22120_(ATTRIBUTE_UUID);
            if (newMax != 0.0f) {
                instance.m_22118_(new AttributeModifier(ATTRIBUTE_UUID, "tconstruct.melee_protection", 0.05 * (double)newMax, AttributeModifier.Operation.ADDITION));
            }
        }
    }
}

