/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends Modifier
implements EquipmentChangeModifierHook {
    private final TinkerDataCapability.ComputableDataKey<T> key;
    private final boolean allowClient;

    public AbstractProtectionModifier(TinkerDataCapability.ComputableDataKey<T> key) {
        this(key, false);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.EQUIPMENT_CHANGE);
    }

    protected void reset(T data, EquipmentChangeContext context) {
    }

    protected void set(T data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        ((ModifierMaxLevel)data).set(slot, scaledLevel);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if ((this.allowClient || !context.getEntity().f_19853_.f_46443_) && ModifierUtil.validArmorSlot(tool, slot)) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    this.set(modData, slot, 0.0f, context);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData, context);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if ((this.allowClient || !context.getEntity().f_19853_.f_46443_) && ModifierUtil.validArmorSlot(tool, slot) && !tool.isBroken()) {
            float scaledLevel = modifier.getEffectiveLevel();
            context.getTinkerData().ifPresent(data -> this.set((ModifierMaxLevel)data.computeIfAbsent(this.key), slot, scaledLevel, context));
        }
    }

    public AbstractProtectionModifier(TinkerDataCapability.ComputableDataKey<T> key, boolean allowClient) {
        this.key = key;
        this.allowClient = allowClient;
    }
}

