/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;

public class GuiMeltingModule {
    private static final ScalableElementScreen PROGRESS_BAR = new ScalableElementScreen(176, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_HEAT_BAR = new ScalableElementScreen(179, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen NO_SPACE_BAR = new ScalableElementScreen(182, 150, 3, 16, 256, 256);
    private static final ScalableElementScreen UNMELTABLE_BAR = new ScalableElementScreen(185, 150, 3, 16, 256, 256);
    private static final Component TOOLTIP_NO_HEAT = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_heat"));
    private static final Component TOOLTIP_NO_SPACE = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_space"));
    private static final Component TOOLTIP_UNMELTABLE = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_recipe"));
    private final AbstractContainerScreen<?> screen;
    private final MeltingModuleInventory inventory;
    private final IntSupplier temperature;
    private final Predicate<Slot> slotPredicate;

    public void drawHeatBars(PoseStack matrices) {
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.m_6262_().f_38839_.get(i);
            if (!slot.m_6657_() || !this.slotPredicate.test(slot)) continue;
            ScalableElementScreen bar = PROGRESS_BAR;
            int index = slot.getSlotIndex();
            int currentTemp = this.inventory.getCurrentTime(index);
            int requiredTime = this.inventory.getRequiredTime(index);
            float progress = 1.0f;
            if (requiredTime == 0) {
                bar = UNMELTABLE_BAR;
            } else if (this.inventory.getRequiredTemp(index) > temperature) {
                bar = NO_HEAT_BAR;
            } else if (currentTemp < 0) {
                bar = NO_SPACE_BAR;
                progress = 1.0f;
            } else if (currentTemp <= requiredTime) {
                progress = (float)currentTemp / (float)requiredTime;
            }
            GuiUtil.drawProgressUp(matrices, (ElementScreen)bar, slot.f_40220_ - 4, slot.f_40221_, progress);
        }
    }

    public void drawHeatTooltips(PoseStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.m_6262_().f_38839_.get(i);
            if (!slot.m_6657_() || !this.slotPredicate.test(slot) || !GuiUtil.isHovered(checkX, checkY, slot.f_40220_ - 5, slot.f_40221_ - 1, GuiMeltingModule.PROGRESS_BAR.w + 1, GuiMeltingModule.PROGRESS_BAR.h + 2)) continue;
            int index = slot.getSlotIndex();
            Component tooltip = null;
            if (this.inventory.getRequiredTime(index) == 0) {
                tooltip = TOOLTIP_UNMELTABLE;
            } else if (this.inventory.getRequiredTemp(slot.getSlotIndex()) > temperature) {
                tooltip = TOOLTIP_NO_HEAT;
            } else if (this.inventory.getCurrentTime(index) < 0) {
                tooltip = TOOLTIP_NO_SPACE;
            }
            if (tooltip == null) break;
            this.screen.m_96602_(matrices, tooltip, mouseX, mouseY);
            break;
        }
    }

    public GuiMeltingModule(AbstractContainerScreen<?> screen, MeltingModuleInventory inventory, IntSupplier temperature, Predicate<Slot> slotPredicate) {
        this.screen = screen;
        this.inventory = inventory;
        this.temperature = temperature;
        this.slotPredicate = slotPredicate;
    }
}

