/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.client.book.TinkerBook;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.client.FluidParticle;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonsClientEvents
extends ClientEventBase {
    private static Font unicodeRenderer;

    @SubscribeEvent
    static void addResourceListeners(RegisterClientReloadListenersEvent event) {
        DomainDisplayName.addResourceListener(event);
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        Font unicode;
        TinkerBook.MATERIALS_AND_YOU.fontRenderer = unicode = CommonsClientEvents.unicodeFontRender();
        TinkerBook.TINKERS_GADGETRY.fontRenderer = unicode;
        TinkerBook.PUNY_SMELTING.fontRenderer = unicode;
        TinkerBook.MIGHTY_SMELTING.fontRenderer = unicode;
        TinkerBook.FANTASTIC_FOUNDRY.fontRenderer = unicode;
        TinkerBook.ENCYCLOPEDIA.fontRenderer = unicode;
    }

    @SubscribeEvent
    static void registerColorHandlers(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            Block block = (Block)TinkerCommons.clearStainedGlass.get((Enum)color);
            Block pane = (Block)TinkerCommons.clearStainedGlassPane.get((Enum)color);
            blockColors.m_92589_((state, reader, pos, index) -> color.getColor(), new Block[]{block, pane});
            CommonsClientEvents.registerBlockItemColorAlias(blockColors, itemColors, block);
            CommonsClientEvents.registerBlockItemColorAlias(blockColors, itemColors, pane);
        }
    }

    @SubscribeEvent
    static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)TinkerCommons.fluidParticle.get(), (ParticleProvider)new FluidParticle.Factory());
    }

    public static Font unicodeFontRender() {
        if (unicodeRenderer == null) {
            unicodeRenderer = new Font(rl -> {
                FontManager resourceManager = Minecraft.m_91087_().f_91045_;
                return (FontSet)resourceManager.f_94999_.get(Minecraft.f_91058_);
            }, false);
        }
        return unicodeRenderer;
    }
}

