/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipe
implements IDisplayPartBuilderRecipe {
    public static final RecordLoadable<ItemPartRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)MaterialVariantId.LOADABLE.defaultField("material", (Object)IMaterial.UNKNOWN_ID, r -> r.material.getVariant()), (RecordField)Pattern.PARSER.requiredField("pattern", ItemPartRecipe::getPattern), (RecordField)IngredientLoadable.DISALLOW_EMPTY.defaultField("pattern_item", (Object)DEFAULT_PATTERNS, r -> r.patternItem), (RecordField)IntLoadable.FROM_ZERO.defaultField("cost", (Object)0, ItemPartRecipe::getCost), (RecordField)ItemOutput.Loadable.REQUIRED_STACK.requiredField("result", r -> r.result), ItemPartRecipe::new).validate((recipe, error) -> {
        if (recipe.cost == 0 && !recipe.material.isEmpty()) {
            throw error.create("Cost must be greater than zero if material is defined");
        }
        return recipe;
    });
    private final ResourceLocation id;
    private final MaterialVariant material;
    private final Pattern pattern;
    private final Ingredient patternItem;
    private final int cost;
    private final ItemOutput result;

    public ItemPartRecipe(ResourceLocation id, MaterialVariantId material, Pattern pattern, Ingredient patternItem, int cost, ItemOutput result) {
        this.id = id;
        this.material = MaterialVariant.of(material);
        this.pattern = pattern;
        this.patternItem = patternItem;
        this.cost = cost;
        this.result = result;
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        if (!this.patternItem.test(inv.getPatternStack())) {
            return false;
        }
        if (!inv.getStack().m_41619_()) {
            if (this.material.isEmpty()) {
                return false;
            }
            IMaterialValue materialRecipe = inv.getMaterial();
            return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial());
        }
        return true;
    }

    public boolean matches(IPartBuilderContainer inv, Level worldIn) {
        if (this.material.isEmpty()) {
            return inv.getStack().m_41619_();
        }
        IMaterialValue materialRecipe = inv.getMaterial();
        return materialRecipe != null && this.material.matchesVariant(materialRecipe.getMaterial()) && inv.getStack().m_41613_() >= materialRecipe.getItemsUsed(this.cost);
    }

    @Override
    public int getItemsUsed(IPartBuilderContainer inv) {
        if (this.material.isEmpty()) {
            return 0;
        }
        return IDisplayPartBuilderRecipe.super.getItemsUsed(inv);
    }

    public ItemStack m_8043_() {
        return this.result.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.itemPartBuilderSerializer.get();
    }

    @Override
    public List<ItemStack> getPatternItems() {
        return Arrays.asList(this.patternItem.m_43908_());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public MaterialVariant getMaterial() {
        return this.material;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }
}

