/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.tinkering.AbstractLootTableInjectionProvider;
import slimeknights.tconstruct.library.json.loot.AddToolDataFunction;
import slimeknights.tconstruct.library.loot.LootTableInjection;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;

public class LootTableInjectionProvider
extends AbstractLootTableInjectionProvider {
    public LootTableInjectionProvider(DataGenerator generator) {
        super(generator, "tconstruct");
    }

    @Override
    protected void addTables() {
        this.inject("slimy_foliage_dungeon", "chests/simple_dungeon", ConfigEnabledCondition.SLIMY_LOOT_CHESTS).addToPool("main", LootTableInjectionProvider.makeSapling(FoliageType.EARTH, 3), LootTableInjectionProvider.makeSapling(FoliageType.SKY, 7)).addToPool("pool1", LootTableInjectionProvider.makeSeed(FoliageType.EARTH, 3), LootTableInjectionProvider.makeSeed(FoliageType.SKY, 7));
        this.inject("slimy_foliage_nether_fortress", "chests/nether_bridge", ConfigEnabledCondition.SLIMY_LOOT_CHESTS).addToPool("main", LootTableInjectionProvider.makeSeed(FoliageType.BLOOD, 5));
        this.inject("slimy_foliage_bastion", "chests/bastion_bridge", ConfigEnabledCondition.SLIMY_LOOT_CHESTS).addToPool("main", LootTableInjectionProvider.makeSapling(FoliageType.BLOOD, 1));
        this.inject("slimy_foliage_end_city", "chests/end_city_treasure", ConfigEnabledCondition.SLIMY_LOOT_CHESTS).addToPool("main", LootTableInjectionProvider.makeSeed(FoliageType.ENDER, 5), LootTableInjectionProvider.makeSapling(FoliageType.ENDER, 3));
        RandomMaterial random = RandomMaterial.random().build();
        AddToolDataFunction.Builder ancientToolData = AddToolDataFunction.builder().addMaterial(random).addMaterial(random);
        this.injectGameplay("piglin_bartering", new ICondition[0]).addToPool("main", LootItem.m_79579_(TinkerSmeltery.scorchedLantern).m_79707_(20).m_79078_((LootItemFunction.Builder)SetFluidLootFunction.builder((FluidStack)new FluidStack(TinkerFluids.blazingBlood.get(), 50))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_7512_()).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.battlesign.get()).m_79707_(5).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        RandomMaterial randomTier1 = RandomMaterial.random().tier(1).build();
        RandomMaterial firstWithStat = RandomMaterial.firstWithStat();
        this.injectChest("spawn_bonus_chest", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.handAxe.get()).m_79707_(2).m_79078_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomTier1).addMaterial(firstWithStat).addMaterial(randomTier1)).m_7512_()).addToPool("pool1", LootItem.m_79579_((ItemLike)TinkerTools.pickaxe.get()).m_79707_(2).m_79078_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomTier1).addMaterial(firstWithStat).addMaterial(randomTier1)).m_7512_());
        AddToolDataFunction.Builder buildData = AddToolDataFunction.builder();
        this.injectChest("ruined_portal", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.flintAndBrick.get()).m_79078_((LootItemFunction.Builder)buildData).m_79707_(30).m_7512_());
        this.injectChest("nether_bridge", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.flintAndBrick.get()).m_79078_((LootItemFunction.Builder)buildData).m_79707_(5).m_7512_());
        this.injectChest("pillager_outpost", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.warPick.get()).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        this.injectChest("abandoned_mineshaft", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.warPick.get()).m_79707_(5).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        this.injectChest("woodland_mansion", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.warPick.get()).m_79707_(10).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        this.inject("hero_of_the_toolsmith", "gameplay/hero_of_the_village/toolsmith", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.warPick.get()).m_79707_(2).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        LootTableInjection.Builder bastion = this.injectChest("bastion_treasure", new ICondition[0]).addToPool("main", LootItem.m_79579_((ItemLike)TinkerTools.battlesign.get()).m_79707_(12).m_79078_((LootItemFunction.Builder)ancientToolData).m_7512_());
        this.injectChest("bastion_other", new ICondition[0]).addToPool("pool1", LootItem.m_79579_((ItemLike)TinkerTools.battlesign.get()).m_79707_(3).m_79078_((LootItemFunction.Builder)ancientToolData).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.9f))).m_7512_());
        RandomMaterial randomHighTier = RandomMaterial.random().tier(3, 4).build();
        for (ArmorSlotType slot : ArmorSlotType.values()) {
            bastion.addToPool("main", LootItem.m_79579_((ItemLike)((ItemLike)TinkerTools.plateArmor.get((Enum)slot))).m_79707_(6).m_79078_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomHighTier).addMaterial(randomHighTier)).m_7512_());
        }
    }

    public String m_6055_() {
        return "Tinkers' Construct Loot Table Injections";
    }

    private static LootPoolEntryContainer makeSeed(FoliageType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeGrassSeeds.get((Enum)type))).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_7512_();
    }

    private static LootPoolEntryContainer makeSapling(FoliageType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeSapling.get((Enum)type))).m_79707_(weight).m_7512_();
    }
}

