/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.sprite;

import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class TinkerPartSpriteProvider
extends AbstractPartSpriteProvider {
    public static final MaterialStatsId WOOD = new MaterialStatsId("tconstruct", "wood");
    public static final MaterialStatsId SLIMESUIT = new MaterialStatsId("tconstruct", "slimesuit");
    public static final MaterialStatsId ARMOR_PLATING = new MaterialStatsId("tconstruct", "armor_plating");
    public static final MaterialStatsId ARMOR_MAILLE = new MaterialStatsId("tconstruct", "armor_maille");

    public TinkerPartSpriteProvider() {
        super("tconstruct");
    }

    @Override
    public String getName() {
        return "Tinkers' Construct Parts";
    }

    @Override
    protected void addAllSpites() {
        this.addHead("round_plate");
        this.addHead("large_plate");
        this.addHead("small_blade");
        this.addHandle("tool_handle");
        this.addHandle("tough_handle");
        this.addBowstring("bowstring");
        this.addBinding("tool_binding");
        this.addPart("repair_kit", StatlessMaterialStats.REPAIR_KIT.getIdentifier());
        this.addPart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
        for (ArmorSlotType slot : ArmorSlotType.values()) {
            this.buildTool("armor/plate/" + slot.m_7912_()).addBreakablePart("plating", PlatingMaterialStats.TYPES.get(slot.getIndex()).getId()).addBreakablePart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
        }
        this.addTexture("tinker_armor/plate/plating_armor", ARMOR_PLATING, false);
        this.addTexture("tinker_armor/plate/plating_leggings", ARMOR_PLATING, false);
        this.addTexture("tinker_armor/plate/maille_armor", ARMOR_MAILLE, false);
        this.addTexture("tinker_armor/plate/maille_leggings", ARMOR_MAILLE, false);
        this.addTexture("tinker_armor/plate/maille_wings", ARMOR_MAILLE, false);
        this.buildTool("armor/plate/shield").addBreakablePart("plating", PlatingMaterialStats.SHIELD.getId()).addBreakablePart("core", StatlessMaterialStats.SHIELD_CORE.getIdentifier()).addBreakablePart("plating_large", PlatingMaterialStats.SHIELD.getId()).addBreakablePart("core_large", StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        this.addSprite("armor/travelers/shield_modifiers/tconstruct_embellishment", WOOD);
        this.addSprite("armor/travelers/shield_modifiers/broken/tconstruct_embellishment", WOOD);
        this.addSprite("staff/modifiers/tconstruct_embellishment", WOOD);
        this.addSprite("staff/large_modifiers/tconstruct_embellishment", WOOD);
        this.addSprite("armor/slime/skull_modifiers/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/skull_modifiers/broken/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/wings_modifiers/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/wings_modifiers/broken/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/shell_modifiers/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/shell_modifiers/broken/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/boot_modifiers/tconstruct_embellishment", SLIMESUIT);
        this.addSprite("armor/slime/boot_modifiers/broken/tconstruct_embellishment", SLIMESUIT);
        this.addTexture("tinker_armor/slime/armor", SLIMESUIT, false);
        this.addTexture("tinker_armor/slime/leggings", SLIMESUIT, false);
        this.addTexture("tinker_armor/slime/wings", SLIMESUIT, false);
        this.buildTool("pickaxe").addBreakableHead("head").addHandle("handle").addBinding("binding");
        this.buildTool("sledge_hammer").withLarge().addBreakableHead("head").addBreakableHead("back").addBreakableHead("front").addHandle("handle");
        this.buildTool("vein_hammer").withLarge().addBreakableHead("head").addHead("back").addBreakableHead("front").addHandle("handle");
        this.buildTool("mattock").addBreakableHead("axe").addBreakableHead("pick");
        this.buildTool("pickadze").addBreakableHead("axe");
        this.buildTool("excavator").withLarge().addBreakableHead("head").addHead("binding").addHandle("handle").addHandle("grip");
        this.buildTool("hand_axe").addBreakableHead("head").addBinding("binding");
        this.buildTool("broad_axe").withLarge().addBreakableHead("blade").addBreakableHead("back").addHandle("handle").addBinding("binding");
        this.buildTool("kama").addBreakableHead("head").addBinding("binding");
        this.buildTool("scythe").withLarge().addBreakableHead("head").addHandle("handle").addHandle("accessory").addBinding("binding");
        this.buildTool("dagger").addBreakableHead("blade").addHandle("crossguard");
        this.buildTool("sword").addBreakableHead("blade").addHandle("guard").addHandle("handle");
        this.buildTool("cleaver").withLarge().addBreakableHead("head").addBreakableHead("shield").addHandle("handle").addHandle("guard");
        this.buildTool("crossbow").addLimb("limb").addGrip("body").addBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
        this.buildTool("longbow").withLarge().addLimb("limb_bottom").addLimb("limb_bottom_1").addLimb("limb_bottom_2").addLimb("limb_bottom_3").addLimb("limb_top").addLimb("limb_top_1").addLimb("limb_top_2").addLimb("limb_top_3").addGrip("grip").addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
    }
}

