/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.function.IntConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationRepairRecipe
implements ITinkerStationRecipe {
    protected static final RecipeResult<ItemStack> FULLY_REPAIRED = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "tool_repair.fully_repaired"), new Object[0]);
    private static final IntConsumer NO_ACTION = i -> {};
    private final ResourceLocation id;

    protected static MaterialId getMaterialFrom(ITinkerStationContainer inv, int slot) {
        ItemStack item = inv.getInput(slot);
        Item item2 = item.m_41720_();
        if (item2 instanceof IRepairKitItem) {
            IRepairKitItem kit = (IRepairKitItem)item2;
            return kit.getMaterial(item).getId();
        }
        MaterialRecipe recipe = inv.getInputMaterial(slot);
        if (recipe != null) {
            return recipe.getMaterial().getId();
        }
        return IMaterial.UNKNOWN_ID;
    }

    protected float getRepairAmount(IToolStackView tool, MaterialId repairMaterial) {
        return MaterialRepairToolHook.repairAmount(tool, repairMaterial);
    }

    protected float getRepairPerItem(ToolStack tool, ITinkerStationContainer inv, int slot, MaterialId repairMaterial) {
        float amount = this.getRepairAmount(tool, repairMaterial);
        if (amount > 0.0f) {
            ItemStack stack = inv.getInput(slot);
            Item item = stack.m_41720_();
            if (item instanceof IRepairKitItem) {
                IRepairKitItem kit = (IRepairKitItem)item;
                return amount * kit.getRepairAmount() / 3.0f;
            }
            MaterialRecipe recipe = inv.getInputMaterial(slot);
            if (recipe != null) {
                return recipe.scaleRepair(amount);
            }
        }
        return 0.0f;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !tinkerable.m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        MaterialId material = null;
        ToolStack tool = inv.getTinkerable();
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            MaterialId inputMaterial = TinkerStationRepairRecipe.getMaterialFrom(inv, i);
            if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
                return false;
            }
            if (!(material == null ? !MaterialRepairToolHook.canRepairWith(tool, material = inputMaterial) : !material.equals(inputMaterial))) continue;
            return false;
        }
        return material != null;
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        int repairNeeded;
        ToolStack tool = inv.getTinkerable();
        if (tool.getDefinition() == ToolDefinition.EMPTY) {
            return RecipeResult.pass();
        }
        if (!tool.isBroken() && tool.getDamage() == 0) {
            return FULLY_REPAIRED;
        }
        int repairRemaining = repairNeeded = tool.getDamage();
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(tool, inv, repairRemaining, i, NO_ACTION), ++i) {
        }
        if (repairRemaining < repairNeeded) {
            tool = tool.copy();
            ToolDamageUtil.repair(tool, repairNeeded - repairRemaining);
            return RecipeResult.success(tool.createStack());
        }
        return RecipeResult.pass();
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        int slot;
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        int repairRemaining = inputTool.getDamage() - resultTool.getDamage();
        for (int i = 0; i < inv.getInputCount() && repairRemaining > 0; repairRemaining -= this.repairFromSlot(inputTool, inv, repairRemaining, i, count -> inv.shrinkInput(slot, count)), ++i) {
            slot = i;
        }
        if (repairRemaining > 0) {
            TConstruct.LOG.error("Recipe repair on {} consumed too few items. {} durability unaccounted for", (Object)result, (Object)repairRemaining);
        }
    }

    protected int repairFromSlot(ToolStack tool, ITinkerStationContainer inv, int repairNeeded, int slot, IntConsumer amountConsumer) {
        float durabilityPerItem;
        MaterialId repairMaterial;
        ItemStack stack = inv.getInput(slot);
        if (!stack.m_41619_() && !(repairMaterial = TinkerStationRepairRecipe.getMaterialFrom(inv, slot)).equals(IMaterial.UNKNOWN_ID) && (durabilityPerItem = this.getRepairPerItem(tool, inv, slot, repairMaterial)) > 0.0f) {
            for (ModifierEntry entry : tool.getModifierList()) {
                durabilityPerItem = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, durabilityPerItem);
                if (!(durabilityPerItem <= 0.0f)) continue;
                return 0;
            }
            int applied = Math.min(stack.m_41613_(), (int)Math.ceil((float)repairNeeded / durabilityPerItem));
            amountConsumer.accept(applied);
            return (int)((float)applied * durabilityPerItem);
        }
        return 0;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationRepairSerializer.get();
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public TinkerStationRepairRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

