/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.item.EdibleItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.data.model.ModelSpriteProvider;
import slimeknights.tconstruct.common.data.model.TinkerBlockStateProvider;
import slimeknights.tconstruct.common.data.model.TinkerItemModelProvider;
import slimeknights.tconstruct.common.json.BlockOrEntityCondition;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.json.condition.TagDifferencePresentCondition;
import slimeknights.tconstruct.library.json.condition.TagIntersectionPresentCondition;
import slimeknights.tconstruct.library.json.condition.TagNotEmptyCondition;
import slimeknights.tconstruct.library.json.loot.TagPreferenceLootEntry;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.recipe.ingredient.BlockTagIngredient;
import slimeknights.tconstruct.library.recipe.ingredient.NoContainerIngredient;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.BetterPaneBlock;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassPaneBlock;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.shared.block.PlatformBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.block.SoulGlassBlock;
import slimeknights.tconstruct.shared.block.SoulGlassPaneBlock;
import slimeknights.tconstruct.shared.block.WaxedPlatformBlock;
import slimeknights.tconstruct.shared.block.WeatheringPlatformBlock;
import slimeknights.tconstruct.shared.command.TConstructCommand;
import slimeknights.tconstruct.shared.data.CommonRecipeProvider;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.shared.item.CheeseBlockItem;
import slimeknights.tconstruct.shared.item.CheeseItem;
import slimeknights.tconstruct.shared.item.TinkerBookItem;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public final class TinkerCommons
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_commons");
    public static final Material GLOW = new Material.Builder(MaterialColor.f_76398_).m_76354_().m_76360_().m_76353_().m_76357_().m_76356_().m_76359_();
    public static final RegistryObject<GlowBlock> glow = BLOCKS.registerNoItem("glow", () -> new GlowBlock(TinkerCommons.builder(GLOW, SoundType.f_56745_).m_60978_(0.0f).m_60953_(s -> 14).m_60955_()));
    public static final ItemObject<GlassBlock> clearGlass = BLOCKS.register("clear_glass", () -> new GlassBlock(TinkerCommons.glassBuilder(MaterialColor.f_76398_)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<TintedGlassBlock> clearTintedGlass = BLOCKS.register("clear_tinted_glass", () -> new TintedGlassBlock(TinkerCommons.glassBuilder(MaterialColor.f_76419_).m_155949_(MaterialColor.f_76419_).m_60955_().m_60922_(Blocks::m_50778_).m_60924_(Blocks::m_50805_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> clearGlassPane = BLOCKS.register("clear_glass_pane", () -> new ClearGlassPaneBlock(TinkerCommons.glassBuilder(MaterialColor.f_76398_)), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassBlock> clearStainedGlass = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass", color -> new ClearStainedGlassBlock(TinkerCommons.glassBuilder(color.getDye().m_41069_()), (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassPaneBlock> clearStainedGlassPane = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass_pane", color -> new ClearStainedGlassPaneBlock(TinkerCommons.glassBuilder(color.getDye().m_41069_()), (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<GlassBlock> soulGlass = BLOCKS.register("soul_glass", () -> new SoulGlassBlock(TinkerCommons.glassBuilder(MaterialColor.f_76362_).m_60956_(0.2f).m_60910_().m_60971_((state, getter, pos) -> true)), GENERAL_TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> soulGlassPane = BLOCKS.register("soul_glass_pane", () -> new SoulGlassPaneBlock(TinkerCommons.glassBuilder(MaterialColor.f_76362_).m_60956_(0.2f)), GENERAL_TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<IronBarsBlock> goldBars = BLOCKS.register("gold_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_()), GENERAL_TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<Block> obsidianPane = BLOCKS.register("obsidian_pane", () -> new BetterPaneBlock(TinkerCommons.builder(Material.f_76278_, MaterialColor.f_76370_, SoundType.f_56742_).m_60999_().m_60955_().m_60913_(25.0f, 400.0f)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> goldPlatform = BLOCKS.register("gold_platform", () -> new PlatformBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76366_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> ironPlatform = BLOCKS.register("iron_platform", () -> new PlatformBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM);
    public static final ItemObject<PlatformBlock> cobaltPlatform = BLOCKS.register("cobalt_platform", () -> new PlatformBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76361_).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM);
    public static final EnumObject<WeatheringCopper.WeatherState, PlatformBlock> copperPlatform = new EnumObject.Builder(WeatheringCopper.WeatherState.class).put((Enum)WeatheringCopper.WeatherState.UNAFFECTED, (Supplier)BLOCKS.register("copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.UNAFFECTED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76413_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.EXPOSED, (Supplier)BLOCKS.register("exposed_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.EXPOSED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76380_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.WEATHERED, (Supplier)BLOCKS.register("weathered_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.WEATHERED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76393_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.OXIDIZED, (Supplier)BLOCKS.register("oxidized_copper_platform", () -> new WeatheringPlatformBlock(WeatheringCopper.WeatherState.OXIDIZED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76392_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).build();
    public static final EnumObject<WeatheringCopper.WeatherState, PlatformBlock> waxedCopperPlatform = new EnumObject.Builder(WeatheringCopper.WeatherState.class).put((Enum)WeatheringCopper.WeatherState.UNAFFECTED, (Supplier)BLOCKS.register("waxed_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.UNAFFECTED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76413_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.EXPOSED, (Supplier)BLOCKS.register("waxed_exposed_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.EXPOSED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76380_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.WEATHERED, (Supplier)BLOCKS.register("waxed_weathered_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.WEATHERED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76393_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).put((Enum)WeatheringCopper.WeatherState.OXIDIZED, (Supplier)BLOCKS.register("waxed_oxidized_copper_platform", () -> new WaxedPlatformBlock(WeatheringCopper.WeatherState.OXIDIZED, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76392_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154663_).m_60955_()), GENERAL_BLOCK_ITEM)).build();
    public static final ItemObject<EdibleItem> bacon = ITEMS.register("bacon", () -> new EdibleItem(TinkerFood.BACON, TAB_GENERAL));
    public static final ItemObject<EdibleItem> jeweledApple = ITEMS.register("jeweled_apple", () -> new EdibleItem(TinkerFood.JEWELED_APPLE, TAB_GENERAL));
    public static final ItemObject<Item> cheeseIngot = ITEMS.register("cheese_ingot", () -> new CheeseItem(new Item.Properties().m_41491_(TAB_GENERAL).m_41489_(TinkerFood.CHEESE)));
    public static final ItemObject<Block> cheeseBlock = BLOCKS.register("cheese_block", () -> new HalfTransparentBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76416_).m_60913_(1.5f, 3.0f).m_60956_(0.4f).m_60967_(0.5f).m_60918_(SoundType.f_56751_).m_60955_()), block -> new CheeseBlockItem((Block)block, new Item.Properties().m_41491_(TAB_GENERAL).m_41489_(TinkerFood.CHEESE)));
    private static final Item.Properties BOOK = new Item.Properties().m_41491_(TAB_GENERAL).m_41487_(1);
    public static final ItemObject<TinkerBookItem> materialsAndYou = ITEMS.register("materials_and_you", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MATERIALS_AND_YOU));
    public static final ItemObject<TinkerBookItem> punySmelting = ITEMS.register("puny_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.PUNY_SMELTING));
    public static final ItemObject<TinkerBookItem> mightySmelting = ITEMS.register("mighty_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MIGHTY_SMELTING));
    public static final ItemObject<TinkerBookItem> tinkersGadgetry = ITEMS.register("tinkers_gadgetry", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.TINKERS_GADGETRY));
    public static final ItemObject<TinkerBookItem> fantasticFoundry = ITEMS.register("fantastic_foundry", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.FANTASTIC_FOUNDRY));
    public static final ItemObject<TinkerBookItem> encyclopedia = ITEMS.register("encyclopedia", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.ENCYCLOPEDIA));
    public static final RegistryObject<ParticleType<FluidParticleData>> fluidParticle = PARTICLE_TYPES.register("fluid", FluidParticleData.Type::new);
    public static final RegistryObject<LootItemConditionType> lootConfig = LOOT_CONDITIONS.register(ConfigEnabledCondition.ID.m_135815_(), () -> new LootItemConditionType((Serializer)ConfigEnabledCondition.SERIALIZER));
    public static final RegistryObject<LootItemConditionType> lootBlockOrEntity = LOOT_CONDITIONS.register("block_or_entity", () -> new LootItemConditionType((Serializer)new BlockOrEntityCondition.ConditionSerializer()));
    public static final RegistryObject<LootItemConditionType> lootTagNotEmptyCondition = LOOT_CONDITIONS.register("tag_not_empty", () -> new LootItemConditionType((Serializer)new TagNotEmptyCondition.ConditionSerializer()));
    public static final RegistryObject<LootPoolEntryType> lootTagPreference = LOOT_ENTRIES.register("tag_preference", () -> new LootPoolEntryType((Serializer)new TagPreferenceLootEntry.Serializer()));
    public static final EnumObject<SlimeType, Item> slimeball = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, () -> Items.f_42518_).putAll(ITEMS.registerEnum(SlimeType.TINKER, "slime_ball", type -> new Item(GENERAL_PROPS))).build();
    public static final BlockContainerOpenedTrigger CONTAINER_OPENED_TRIGGER = new BlockContainerOpenedTrigger();

    public TinkerCommons() {
        TConstructCommand.init();
        MinecraftForge.EVENT_BUS.addListener(RecipeCacheInvalidator::onReloadListenerReload);
    }

    @SubscribeEvent
    void commonSetupEvent(FMLCommonSetupEvent event) {
        SlimeBounceHandler.init();
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registry.f_122915_) {
            CraftingHelper.register((ResourceLocation)NoContainerIngredient.ID, (IIngredientSerializer)NoContainerIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)BlockTagIngredient.Serializer.ID, (IIngredientSerializer)BlockTagIngredient.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)ConfigEnabledCondition.SERIALIZER);
            CriteriaTriggers.m_10595_((CriterionTrigger)CONTAINER_OPENED_TRIGGER);
            CraftingHelper.register((IConditionSerializer)TagIntersectionPresentCondition.SERIALIZER);
            CraftingHelper.register((IConditionSerializer)TagDifferencePresentCondition.SERIALIZER);
            CraftingHelper.register((IConditionSerializer)new TagNotEmptyCondition.ConditionSerializer());
            LivingEntityPredicate.LOADER.register(TConstruct.getResource("airborne"), TinkerPredicate.AIRBORNE.getLoader());
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        generator.m_236039_(client, (DataProvider)new ModelSpriteProvider(generator, existingFileHelper));
        generator.m_236039_(client, (DataProvider)new TinkerItemModelProvider(generator, existingFileHelper));
        generator.m_236039_(client, (DataProvider)new TinkerBlockStateProvider(generator, existingFileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new CommonRecipeProvider(generator));
    }
}

