/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public final class ToolBuildHandler {
    private static final MaterialId RENDER_MATERIAL = new MaterialId("tconstruct", "ui_render");
    private static final List<MaterialVariantId> RENDER_MATERIALS = Arrays.asList(MaterialVariantId.create(RENDER_MATERIAL, "head"), MaterialVariantId.create(RENDER_MATERIAL, "handle"), MaterialVariantId.create(RENDER_MATERIAL, "extra"), MaterialVariantId.create(RENDER_MATERIAL, "large"), MaterialVariantId.create(RENDER_MATERIAL, "extra_large"));

    private ToolBuildHandler() {
    }

    public static ItemStack buildItemFromMaterials(IModifiable tool, MaterialNBT materials) {
        return ToolStack.createTool(tool.m_5456_(), tool.getToolDefinition(), materials).createStack();
    }

    public static MaterialVariantId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (!definition.isDataLoaded() || definition.hasMaterials()) {
            stack = new MaterialIdNBT(RENDER_MATERIALS).updateStack(stack);
        }
        stack.m_41784_().m_128379_("tic_display", true);
        return stack;
    }

    public static void addDefaultSubItems(IModifiable item, List<ItemStack> itemList) {
        block3: {
            IMaterial material2;
            MaterialId materialId;
            block4: {
                boolean hasMaterials;
                block2: {
                    ToolDefinition definition = item.getToolDefinition();
                    hasMaterials = definition.hasMaterials();
                    if (definition.isDataLoaded() && (!hasMaterials || MaterialRegistry.isFullyLoaded())) break block2;
                    itemList.add(new ItemStack((ItemLike)item));
                    break block3;
                }
                if (hasMaterials) break block4;
                itemList.add(ToolBuildHandler.buildItemFromMaterials(item, MaterialNBT.EMPTY));
                break block3;
            }
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryParse(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && ToolBuildHandler.addSubItem(item, itemList, MaterialVariant.of(material2))) {
                added = true;
            }
            if (added) break block3;
            for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                if (ToolBuildHandler.addSubItem(item, itemList, MaterialVariant.of(material2)) && !showOnlyId.isEmpty()) break;
            }
        }
    }

    public static boolean addSubItem(IModifiable item, List<ItemStack> items, MaterialVariant material) {
        List<MaterialStatsId> required = ToolMaterialHook.stats(item.getToolDefinition());
        MaterialNBT.Builder materials = MaterialNBT.builder();
        boolean useMaterial = false;
        for (MaterialStatsId requirement : required) {
            if (requirement.canUseMaterial(material.getId())) {
                materials.add(material);
                useMaterial = true;
                continue;
            }
            materials.add(MaterialRegistry.firstWithStatType(requirement));
        }
        if (useMaterial) {
            items.add(ToolBuildHandler.buildItemFromMaterials(item, materials.build()));
            return true;
        }
        return false;
    }

    public static ItemStack getDisplayPart(IToolPart toolPart, int i) {
        ItemStack item = toolPart.withMaterialForDisplay(ToolBuildHandler.getRenderMaterial(i));
        item.m_41784_().m_128379_("tic_display", true);
        return item;
    }
}

