/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.RegistryLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class TinkerLoadables {
    public static final StringLoadable<AttributeModifier.Operation> OPERATION = new EnumLoadable(AttributeModifier.Operation.class);
    public static final StringLoadable<EquipmentSlot> EQUIPMENT_SLOT = new EnumLoadable(EquipmentSlot.class);
    public static final Loadable<Set<EquipmentSlot>> EQUIPMENT_SLOT_SET = EQUIPMENT_SLOT.set();
    public static final StringLoadable<LightLayer> LIGHT_LAYER = new EnumLoadable(LightLayer.class);
    public static final StringLoadable<InteractionSource> INTERACTION_SOURCE = new EnumLoadable(InteractionSource.class);
    public static final StringLoadable<IMeltingContainer.OreRateType> ORE_RATE_TYPE = new EnumLoadable(IMeltingContainer.OreRateType.class);
    public static final StringLoadable<ResourceLocation> CUSTOM_STAT = new RegistryLoadable(Registry.f_122832_);
    public static final StringLoadable<TagKey<Modifier>> MODIFIER_TAGS = Loadables.tagKey(ModifierManager.REGISTRY_KEY);
    public static final StringLoadable<TagKey<IMaterial>> MATERIAL_TAGS = Loadables.tagKey(MaterialManager.REGISTRY_KEY);
    public static final StringLoadable<IMaterialItem> MATERIAL_ITEM = TinkerLoadables.instance(Loadables.ITEM, IMaterialItem.class, "Expected item to be instance of IMaterialItem");
    public static final StringLoadable<IModifiable> MODIFIABLE_ITEM = TinkerLoadables.instance(Loadables.ITEM, IModifiable.class, "Expected item to be instance of IModifiable");
    public static final StringLoadable<IToolPart> TOOL_PART_ITEM = TinkerLoadables.instance(Loadables.ITEM, IToolPart.class, "Expected item to be instance of IToolPart");
    public static final StringLoadable<Tier> TIER = Loadables.RESOURCE_LOCATION.xmap((id, error) -> {
        Tier tier = TierSortingRegistry.byName((ResourceLocation)id);
        if (tier != null) {
            return tier;
        }
        throw error.create("Unknown harvest tier " + id);
    }, (tier, error) -> {
        ResourceLocation id = TierSortingRegistry.getName((Tier)tier);
        if (id != null) {
            return id;
        }
        throw error.create("Attempt to serialize unregistered tier " + tier);
    });

    public static <B, T> StringLoadable<T> instance(StringLoadable<B> loadable, Class<T> typeClass, String errorMsg) {
        return loadable.comapFlatMap((base, error) -> {
            if (typeClass.isInstance(base)) {
                return typeClass.cast(base);
            }
            throw error.create(errorMsg);
        }, t -> t);
    }
}

