/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.model;

import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.data.model.MaterialModelBuilder;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class TinkerItemModelProvider
extends ItemModelProvider {
    public TinkerItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "tconstruct", existingFileHelper);
    }

    protected void registerModels() {
        this.part(TinkerToolParts.pickHead, "pickaxe/head").offset(-2, 1);
        this.part(TinkerToolParts.hammerHead, "sledge_hammer/head").offset(-3, 3);
        this.part(TinkerToolParts.smallAxeHead, "hand_axe/head").offset(-2, 3);
        this.part(TinkerToolParts.broadAxeHead, "broad_axe/blade").offset(0, 3);
        this.part(TinkerToolParts.smallBlade);
        this.part(TinkerToolParts.broadBlade, "cleaver/head").offset(-1, 1);
        this.part(TinkerToolParts.roundPlate);
        this.part(TinkerToolParts.largePlate);
        this.part(TinkerToolParts.bowLimb, "longbow/limb_bottom").offset(5, -2);
        this.part(TinkerToolParts.bowGrip, "crossbow/body").offset(-2, -2);
        this.part(TinkerToolParts.bowstring);
        this.part(TinkerToolParts.toolBinding);
        this.part(TinkerToolParts.toolHandle);
        this.part(TinkerToolParts.toughHandle);
        this.part(TinkerToolParts.repairKit);
        TinkerToolParts.plating.forEach((slot, item) -> {
            MaterialModelBuilder<ItemModelBuilder> b = this.part((Item)item, "armor/plate/" + slot.m_7912_() + "/plating");
            if (slot == ArmorSlotType.HELMET) {
                b.offset(0, 2);
            } else if (slot == ArmorSlotType.LEGGINGS) {
                b.offset(0, 1);
            }
        });
        this.part(TinkerToolParts.maille);
        this.part(TinkerToolParts.shieldCore, "armor/plate/shield/core");
        this.basicItem((ItemLike)TinkerSmeltery.blankSandCast, "sand_cast/blank");
        this.basicItem((ItemLike)TinkerSmeltery.blankRedSandCast, "red_sand_cast/blank");
        this.cast(TinkerSmeltery.ingotCast);
        this.cast(TinkerSmeltery.nuggetCast);
        this.cast(TinkerSmeltery.gemCast);
        this.cast(TinkerSmeltery.rodCast);
        this.cast(TinkerSmeltery.repairKitCast);
        this.cast(TinkerSmeltery.plateCast);
        this.cast(TinkerSmeltery.gearCast);
        this.cast(TinkerSmeltery.coinCast);
        this.cast(TinkerSmeltery.wireCast);
        this.cast(TinkerSmeltery.pickHeadCast);
        this.cast(TinkerSmeltery.smallAxeHeadCast);
        this.cast(TinkerSmeltery.smallBladeCast);
        this.cast(TinkerSmeltery.hammerHeadCast);
        this.cast(TinkerSmeltery.broadBladeCast);
        this.cast(TinkerSmeltery.broadAxeHeadCast);
        this.cast(TinkerSmeltery.toolBindingCast);
        this.cast(TinkerSmeltery.roundPlateCast);
        this.cast(TinkerSmeltery.largePlateCast);
        this.cast(TinkerSmeltery.toolHandleCast);
        this.cast(TinkerSmeltery.toughHandleCast);
        this.cast(TinkerSmeltery.bowLimbCast);
        this.cast(TinkerSmeltery.bowGripCast);
        this.cast(TinkerSmeltery.helmetPlatingCast);
        this.cast(TinkerSmeltery.chestplatePlatingCast);
        this.cast(TinkerSmeltery.leggingsPlatingCast);
        this.cast(TinkerSmeltery.bootsPlatingCast);
        this.cast(TinkerSmeltery.mailleCast);
        TinkerSmeltery.dummyPlating.forEach((type, item) -> this.basicItem((ItemLike)item, "tool/parts/plating_" + type.m_7912_()));
    }

    private ItemModelBuilder basicItem(ResourceLocation item, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + texture));
    }

    private ItemModelBuilder basicItem(ItemLike item, String texture) {
        return this.basicItem(Registry.f_122827_.m_7981_((Object)item.m_5456_()), texture);
    }

    private MaterialModelBuilder<ItemModelBuilder> part(ResourceLocation part, String texture) {
        return (MaterialModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(part.m_135815_(), "forge:item/default")).texture("texture", TConstruct.getResource("item/tool/" + texture))).customLoader(MaterialModelBuilder::new);
    }

    private MaterialModelBuilder<ItemModelBuilder> part(Item item, String texture) {
        return this.part(Registry.f_122827_.m_7981_((Object)item), texture);
    }

    private MaterialModelBuilder<ItemModelBuilder> part(ItemObject<? extends MaterialItem> part, String texture) {
        return this.part(part.getId(), texture);
    }

    private void part(ItemObject<? extends MaterialItem> part) {
        this.part(part, "parts/" + part.getId().m_135815_());
    }

    private void cast(CastItemObject cast) {
        String name = cast.getName().m_135815_();
        this.basicItem(cast.getId(), "cast/" + name);
        this.basicItem((ItemLike)cast.getSand(), "sand_cast/" + name);
        this.basicItem((ItemLike)cast.getRedSand(), "red_sand_cast/" + name);
    }
}

