/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.model;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.mantle.util.IdExtender;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.world.TinkerWorld;

public class TinkerBlockStateProvider
extends BlockStateProvider {
    private final ModelFile.UncheckedModelFile GENERATED = new ModelFile.UncheckedModelFile("item/generated");

    public TinkerBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "tconstruct", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.addFenceBuildingBlock(TinkerMaterials.blazewood, "block/wood/blazewood/", "planks", this.blockTexture("wood/blazewood"));
        this.addFenceBuildingBlock(TinkerMaterials.nahuatl, "block/wood/nahuatl/", "planks", this.blockTexture("wood/nahuatl"));
        this.addWood(TinkerWorld.greenheart, false);
        this.addWood(TinkerWorld.skyroot, true);
        this.addWood(TinkerWorld.bloodshroom, true);
        this.addWood(TinkerWorld.enderbark, true);
        this.basicBlock((Block)TinkerWorld.enderbarkRoots.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/wood/enderbark/roots/empty", "block/mangrove_roots")).texture("side", this.blockTexture("wood/enderbark/roots"))).texture("top", this.blockTexture("wood/enderbark/roots_top")));
        TinkerWorld.slimyEnderbarkRoots.forEach((type, block) -> {
            String name = type.m_7912_();
            this.cubeColumn((Block)block, "block/wood/enderbark/roots/" + name, this.blockTexture("wood/enderbark/roots/" + name), this.blockTexture("wood/enderbark/roots/" + name + "_top"));
        });
    }

    protected ResourceLocation blockTexture(String path) {
        return new ResourceLocation("tconstruct", "block/" + path);
    }

    protected ResourceLocation itemTexture(String path) {
        return new ResourceLocation("tconstruct", "item/" + path);
    }

    protected void addBuildingBlock(BuildingBlockObject block, String folder, String name, ResourceLocation texture) {
        ModelFile blockModel = this.basicBlock((Block)block.get(), folder + name, texture);
        this.slab(block.getSlab(), folder + "slab", blockModel, texture, texture, texture);
        this.stairs(block.getStairs(), folder + "stairs", texture, texture, texture);
    }

    protected void addFenceBuildingBlock(FenceBuildingBlockObject block, String folder, String name, ResourceLocation texture) {
        this.addBuildingBlock((BuildingBlockObject)block, folder, name, texture);
        this.fence(block.getFence(), folder + "fence/", texture);
    }

    protected void addWood(WoodBlockObject wood, boolean trapdoorOrientable) {
        String plankPath = wood.getId().m_135815_();
        String name = plankPath.substring(0, plankPath.length() - "_planks".length());
        String folder = "block/wood/" + name + "/";
        Function<String, ResourceLocation> texture = suffix -> this.blockTexture("wood/" + name + "/" + suffix);
        ResourceLocation planks = texture.apply("planks");
        this.addFenceBuildingBlock((FenceBuildingBlockObject)wood, folder, "planks", planks);
        this.fenceGate(wood.getFenceGate(), folder + "fence/gate", planks);
        this.axisBlock(wood.getLog(), folder + "log/log", texture.apply("log"), true);
        this.axisBlock(wood.getStrippedLog(), folder + "log/stripped", texture.apply("stripped_log"), true);
        this.axisBlock(wood.getWood(), folder + "log/wood", texture.apply("log"), false);
        this.axisBlock(wood.getStrippedWood(), folder + "log/wood_stripped", texture.apply("stripped_log"), false);
        this.door(wood.getDoor(), folder, texture.apply("door_bottom"), texture.apply("door_top"));
        this.basicItem((ItemLike)wood.getDoor(), "wood/");
        this.trapdoor(wood.getTrapdoor(), folder + "trapdoor_", texture.apply("trapdoor"), trapdoorOrientable);
        this.pressurePlate(wood.getPressurePlate(), folder + "pressure_plate", planks);
        this.button((ButtonBlock)wood.getButton(), folder + "button", planks);
        this.signBlock(wood.getSign(), wood.getWallSign(), (ModelFile)this.models().sign(folder + "sign", planks));
        this.basicItem((ItemLike)wood.getSign(), "wood/");
    }

    private ResourceLocation key(Block block) {
        return Registry.f_122824_.m_7981_((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation itemKey(ItemLike item) {
        return Registry.f_122827_.m_7981_((Object)item.m_5456_());
    }

    private String itemName(ItemLike item) {
        return this.itemKey(item).m_135815_();
    }

    protected ItemModelBuilder basicItem(ItemLike item, String texturePrefix) {
        return this.basicItem(this.itemKey(item), texturePrefix);
    }

    protected ItemModelBuilder basicItem(ResourceLocation item, String texturePrefix) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(item.toString())).parent((ModelFile)this.GENERATED)).texture("layer0", this.itemTexture(texturePrefix + item.m_135815_()));
    }

    public ModelFile basicBlock(Block block, ModelFile model) {
        this.simpleBlock(block, model);
        this.simpleBlockItem(block, model);
        return model;
    }

    public ModelFile basicBlock(Block block, String location, ResourceLocation texture) {
        return this.basicBlock(block, (ModelFile)this.models().cubeAll(location, texture));
    }

    public ModelFile cubeColumn(Block block, String location, ResourceLocation side, ResourceLocation top) {
        return this.basicBlock(block, (ModelFile)this.models().cubeColumn(location, side, top));
    }

    public void axisBlock(Block block, String location, ResourceLocation texture, boolean horizontal) {
        ResourceLocation endTexture = horizontal ? IdExtender.INSTANCE.suffix(texture, "_top") : texture;
        ModelBuilder model = this.models().cubeColumn(TConstruct.resourceString(location), texture, endTexture);
        this.axisBlock((RotatedPillarBlock)block, (ModelFile)model, (ModelFile)(horizontal ? this.models().cubeColumnHorizontal(TConstruct.resourceString(location + "_horizontal"), texture, endTexture) : model));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    public void slab(SlabBlock block, String location, ModelFile doubleModel, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ModelBuilder slab = this.models().slab(location, sideTexture, bottomTexture, topTexture);
        this.slabBlock(block, (ModelFile)slab, (ModelFile)this.models().slabTop(location + "_top", sideTexture, bottomTexture, topTexture), doubleModel);
        this.simpleBlockItem((Block)block, (ModelFile)slab);
    }

    public void stairs(StairBlock block, String location, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ModelBuilder stairs = this.models().stairs(location, sideTexture, bottomTexture, topTexture);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)this.models().stairsInner(location + "_inner", sideTexture, bottomTexture, topTexture), (ModelFile)this.models().stairsOuter(location + "_outer", sideTexture, bottomTexture, topTexture));
        this.simpleBlockItem((Block)block, (ModelFile)stairs);
    }

    public void fence(FenceBlock block, String prefix, ResourceLocation texture) {
        this.fourWayBlock((CrossCollisionBlock)block, (ModelFile)this.models().fencePost(prefix + "post", texture), (ModelFile)this.models().fenceSide(prefix + "side", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.itemName((ItemLike)block), "minecraft:block/fence_inventory")).texture("texture", texture);
    }

    public void fenceGate(FenceGateBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder model = this.models().fenceGate(baseName, texture);
        this.fenceGateBlock(block, (ModelFile)model, (ModelFile)this.models().fenceGateOpen(baseName + "_open", texture), (ModelFile)this.models().fenceGateWall(baseName + "_wall", texture), (ModelFile)this.models().fenceGateWallOpen(baseName + "_wall_open", texture));
        this.simpleBlockItem((Block)block, (ModelFile)model);
    }

    public void door(DoorBlock block, String prefix, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.doorBlock(block, (ModelFile)this.models().doorBottomLeft(prefix + "door/bottom_left", bottomTexture, topTexture), (ModelFile)this.models().doorBottomLeftOpen(prefix + "door/bottom_left_open", bottomTexture, topTexture), (ModelFile)this.models().doorBottomRight(prefix + "door/bottom_right", bottomTexture, topTexture), (ModelFile)this.models().doorBottomRightOpen(prefix + "door/bottom_right_open", bottomTexture, topTexture), (ModelFile)this.models().doorTopLeft(prefix + "door/top_left", bottomTexture, topTexture), (ModelFile)this.models().doorTopLeftOpen(prefix + "door/top_left_open", bottomTexture, topTexture), (ModelFile)this.models().doorTopRight(prefix + "door/top_right", bottomTexture, topTexture), (ModelFile)this.models().doorTopRightOpen(prefix + "door/top_right_open", bottomTexture, topTexture));
    }

    public void trapdoor(TrapDoorBlock block, String prefix, ResourceLocation texture, boolean orientable) {
        ModelBuilder bottom = orientable ? this.models().trapdoorOrientableBottom(prefix + "bottom", texture) : this.models().trapdoorBottom(prefix + "bottom", texture);
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)(orientable ? this.models().trapdoorOrientableTop(prefix + "top", texture) : this.models().trapdoorTop(prefix + "top", texture)), (ModelFile)(orientable ? this.models().trapdoorOrientableOpen(prefix + "open", texture) : this.models().trapdoorOpen(prefix + "open", texture)), orientable);
        this.simpleBlockItem((Block)block, (ModelFile)bottom);
    }

    public void pressurePlate(PressurePlateBlock block, String location, ResourceLocation texture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(location, texture);
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)this.models().pressurePlateDown(location + "_down", texture));
        this.simpleBlockItem((Block)block, (ModelFile)pressurePlate);
    }

    public void button(ButtonBlock block, String location, ResourceLocation texture) {
        ModelBuilder button = this.models().button(location, texture);
        this.buttonBlock(block, (ModelFile)button, (ModelFile)this.models().buttonPressed(location + "_pressed", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(this.itemName((ItemLike)block), "minecraft:block/button_inventory")).texture("texture", texture);
    }
}

