/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FarsightedModifier
extends IncrementalModifier {
    private final ResourceLocation[] SLOT_KEYS = (ResourceLocation[])Arrays.stream(EquipmentSlot.values()).sorted(Comparator.comparing(EquipmentSlot::m_20750_)).map(slot -> TConstruct.getResource("farsighted_" + slot.m_20751_())).toArray(ResourceLocation[]::new);

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().m_20750_()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(key, 1.0f / (1.0f + 0.05f * (float)level)));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().m_20750_()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(key));
        }
    }
}

