/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageTakenModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolModuleHooks;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.UseFluidOnHitModifier;

public class SpillingModifier
extends UseFluidOnHitModifier
implements EntityInteractionModifierHook,
DamageTakenModifierHook {
    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.ENTITY_INTERACT, TinkerHooks.DAMAGE_TAKEN);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (damageDealt > 0.0f && context.isFullyCharged() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            FluidStack remaining = recipe.applyEffects(fluid, level, context);
            SpillingModifier.spawnParticles(context.getTarget(), fluid);
            Player player = context.getPlayerAttacker();
            if (player == null || !player.m_7500_()) {
                this.setFluid(tool, remaining);
            }
        }
        return 0;
    }

    @Override
    public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (source != InteractionSource.ARMOR && !tool.hasTag(TinkerTags.Items.MELEE) && tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source) && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            if (!player.f_19853_.f_46443_) {
                LivingEntity l;
                int level = modifier.getLevel();
                ToolAttackContext context = new ToolAttackContext((LivingEntity)player, player, hand, target, target instanceof LivingEntity ? (l = (LivingEntity)target) : null, false, 1.0f, false);
                FluidStack remaining = recipe.applyEffects(fluid.copy(), level, context);
                SpillingModifier.spawnParticles(target, fluid);
                if (!player.m_7500_()) {
                    this.setFluid(tool, remaining);
                }
                int numTargets = 1;
                float range = 1 + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
                float rangeSq = range * range;
                for (Entity aoeTarget : player.f_19853_.m_45976_(Entity.class, target.m_142469_().m_82377_((double)range, 0.25, (double)range))) {
                    LivingEntity l2;
                    ArmorStand stand;
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof ArmorStand && (stand = (ArmorStand)aoeTarget).m_31677_() || !(target.m_20280_(aoeTarget) < (double)rangeSq)) continue;
                    ++numTargets;
                    context = new ToolAttackContext((LivingEntity)player, player, hand, aoeTarget, aoeTarget instanceof LivingEntity ? (l2 = (LivingEntity)aoeTarget) : null, false, 1.0f, true);
                    recipe.applyEffects(fluid.copy(), level, context);
                    SpillingModifier.spawnParticles(aoeTarget, fluid);
                }
                ToolDamageUtil.damageAnimated(tool, numTargets * level, (LivingEntity)player, hand);
            }
            player.m_36335_().m_41524_(tool.getItem(), (int)(20.0f / (tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue() * ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED))));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public ToolAttackContext createContext(LivingEntity self, @Nullable Player player, @Nullable Entity attacker, FluidStack fluid) {
        LivingEntity living;
        assert (attacker != null);
        SpillingModifier.spawnParticles(attacker, fluid);
        return new ToolAttackContext(self, player, InteractionHand.MAIN_HAND, attacker, attacker instanceof LivingEntity ? (living = (LivingEntity)attacker) : null, false, 1.0f, false);
    }

    @Override
    protected boolean doesTrigger(DamageSource source, boolean isDirectDamage) {
        return source.m_7639_() != null && isDirectDamage;
    }

    @Override
    public void onDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        this.useFluid(tool, modifier, context, slotType, source, isDirectDamage);
    }
}

