/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.ranged.ScopeModifier;

public class ModifiableBowItem
extends ModifiableLauncherItem {
    public ModifiableBowItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public Predicate<ItemStack> m_6437_() {
        return ProjectileWeaponItem.f_43005_;
    }

    public int m_6615_() {
        return 15;
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return BlockingModifier.blockWhileCharging(ToolStack.from(stack), UseAnim.BOW);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bow = player.m_21120_(hand);
        ToolStack tool = ToolStack.from(bow);
        if (tool.isBroken()) {
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        boolean hasAmmo = BowAmmoModifierHook.hasAmmo(tool, bow, player, this.m_6442_());
        InteractionResultHolder override = ForgeEventFactory.onArrowNock((ItemStack)bow, (Level)level, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (override != null) {
            return override;
        }
        if (!player.m_150110_().f_35937_ && !hasAmmo) {
            if (ModifierUtil.canPerformAction(tool, ToolActions.SHIELD_BLOCK)) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)bow);
            }
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        player.m_6672_(hand);
        float drawspeed = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED) / 20.0f;
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(DRAWSPEED, Float.valueOf(drawspeed)));
        tool.getPersistentData().putInt(KEY_DRAWTIME, (int)Math.ceil(1.0f / drawspeed));
        if (!level.f_46443_) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.LONGBOW_CHARGE.getSound(), SoundSource.PLAYERS, 0.75f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)bow);
    }

    public void m_5551_(ItemStack bow, Level level, LivingEntity living, int timeLeft) {
        float velocity;
        float power;
        ScopeModifier.stopScoping(living);
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        ToolStack tool = ToolStack.from(bow);
        tool.getPersistentData().remove(KEY_DRAWTIME);
        if (tool.isBroken()) {
            return;
        }
        boolean creative = player.m_150110_().f_35937_;
        boolean hasAmmo = creative || BowAmmoModifierHook.hasAmmo(tool, bow, player, this.m_6442_());
        int chargeTime = this.m_8105_(bow) - timeLeft;
        chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)level, (Player)player, (int)chargeTime, (boolean)hasAmmo);
        if (!hasAmmo || chargeTime < 0) {
            return;
        }
        float charge = (float)chargeTime * ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.DRAW_SPEED) / 20.0f;
        if ((charge = (charge * charge + charge * 2.0f) / 3.0f) > 1.0f) {
            charge = 1.0f;
        }
        if ((power = charge * (velocity = ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY))) < 0.1f) {
            return;
        }
        if (!level.f_46443_) {
            ArrowItem arrow;
            Item item;
            ItemStack ammo = BowAmmoModifierHook.findAmmo(tool, bow, player, this.m_6442_());
            if (ammo.m_41619_()) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
            }
            ArrowItem arrowItem = (item = ammo.m_41720_()) instanceof ArrowItem ? (arrow = (ArrowItem)item) : (ArrowItem)Items.f_42412_;
            float inaccuracy = ModifierUtil.getInaccuracy(tool, living, velocity);
            float startAngle = ModifiableBowItem.getAngleStart(ammo.m_41613_());
            int primaryIndex = ammo.m_41613_() / 2;
            for (int arrowIndex = 0; arrowIndex < ammo.m_41613_(); ++arrowIndex) {
                AbstractArrow arrow2 = arrowItem.m_6394_(level, ammo, (LivingEntity)player);
                float angle = startAngle + (float)(10 * arrowIndex);
                arrow2.m_37251_((Entity)player, player.m_146909_() + angle, player.m_146908_(), 0.0f, power * 3.0f, inaccuracy);
                if (charge == 1.0f) {
                    arrow2.m_36762_(true);
                }
                float baseArrowDamage = (float)(arrow2.m_36789_() - 2.0 + (double)tool.getStats().get(ToolStats.PROJECTILE_DAMAGE).floatValue());
                arrow2.m_36781_((double)ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.PROJECTILE_DAMAGE, baseArrowDamage));
                ModifierNBT modifiers = tool.getModifiers();
                arrow2.getCapability(EntityModifierCapability.CAPABILITY).ifPresent(cap -> cap.setModifiers(modifiers));
                NamespacedNBT arrowData = PersistentDataCapability.getOrWarn((Entity)arrow2);
                if (creative) {
                    arrow2.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                for (ModifierEntry entry : modifiers.getModifiers()) {
                    entry.getHook(TinkerHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, living, (Projectile)arrow2, arrow2, arrowData, arrowIndex == primaryIndex);
                }
                level.m_7967_((Entity)arrow2);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_5822_().nextFloat() * 0.4f + 1.2f) + charge * 0.5f + angle / 10.0f);
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, ammo.m_41613_(), (LivingEntity)player, player.m_7655_());
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }
}

