/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModule;

public class MeltingModuleInventory
implements IItemHandlerModifiable {
    private static final String TAG_SLOT = "slot";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SIZE = "size";
    private final MantleBlockEntity parent;
    protected final IFluidHandler fluidHandler;
    private MeltingModule[] modules;
    private final boolean strictSize;
    private final IMeltingContainer.IOreRate oreRate;

    public MeltingModuleInventory(MantleBlockEntity parent, IFluidHandler fluidHandler, IMeltingContainer.IOreRate oreRate, int size) {
        this.parent = parent;
        this.fluidHandler = fluidHandler;
        this.modules = new MeltingModule[size];
        this.oreRate = oreRate;
        this.strictSize = size != 0;
    }

    public MeltingModuleInventory(MantleBlockEntity parent, IFluidHandler fluidHandler, IMeltingContainer.IOreRate oreRate) {
        this(parent, fluidHandler, oreRate, 0);
    }

    public int getSlots() {
        return this.modules.length;
    }

    public boolean validSlot(int slot) {
        return slot >= 0 && slot < this.getSlots();
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private boolean hasModule(int slot) {
        return this.validSlot(slot) && this.modules[slot] != null;
    }

    public int getCurrentTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getCurrentTime() : 0;
    }

    public int getRequiredTime(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTime() : 0;
    }

    public int getRequiredTemp(int slot) {
        return this.hasModule(slot) ? this.modules[slot].getRequiredTemp() : 0;
    }

    public MeltingModule getModule(int slot) {
        if (!this.validSlot(slot)) {
            throw new IndexOutOfBoundsException();
        }
        if (this.modules[slot] == null) {
            this.modules[slot] = new MeltingModule(this.parent, recipe -> this.tryFillTank(slot, (IMeltingRecipe)recipe), this.oreRate, slot);
        }
        return this.modules[slot];
    }

    public void resize(int newSize, Consumer<ItemStack> stackConsumer) {
        if (this.strictSize) {
            throw new IllegalStateException("Cannot resize this melting module inventory");
        }
        if (newSize == this.modules.length) {
            return;
        }
        if (newSize < this.modules.length) {
            for (int i = newSize; i < this.modules.length; ++i) {
                if (this.modules[i] == null || this.modules[i].getStack().m_41619_()) continue;
                stackConsumer.accept(this.modules[i].getStack());
            }
        }
        this.modules = Arrays.copyOf(this.modules, newSize);
        this.parent.setChangedFast();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.validSlot(slot) && this.modules[slot] != null) {
            return this.modules[slot].getStack();
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.validSlot(slot)) {
            if (stack.m_41619_()) {
                if (this.modules[slot] != null) {
                    this.modules[slot].setStack(ItemStack.f_41583_);
                }
            } else {
                if (stack.m_41613_() > 1) {
                    stack.m_41764_(1);
                }
                this.getModule(slot).setStack(stack);
            }
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return stack;
        }
        MeltingModule module = this.getModule(slot);
        boolean canInsert = module.getStack().m_41619_();
        if (!simulate && canInsert) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        return canInsert ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1)) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (!this.validSlot(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return existing.m_41777_();
        }
        this.setStackInSlot(slot, ItemStack.f_41583_);
        return existing;
    }

    public boolean canHeat(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null || !module.canHeatItem(temperature)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryFillTank(int index, IMeltingRecipe recipe) {
        FluidStack fluid = recipe.getOutput(this.getModule(index));
        if (this.fluidHandler.fill(fluid.copy(), IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()) {
            this.fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public void heatItems(int temperature) {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.heatItem(temperature);
        }
    }

    public void coolItems() {
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.coolItem();
        }
    }

    public CompoundTag writeToTag() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null || this.modules[i].getStack().m_41619_()) continue;
            CompoundTag moduleTag = this.modules[i].writeToTag();
            moduleTag.m_128344_(TAG_SLOT, (byte)i);
            list.add((Object)moduleTag);
        }
        if (!list.isEmpty()) {
            nbt.m_128365_(TAG_ITEMS, (Tag)list);
        }
        nbt.m_128344_(TAG_SIZE, (byte)this.modules.length);
        return nbt;
    }

    public void readFromTag(CompoundTag nbt) {
        int newSize;
        if (!this.strictSize && (newSize = nbt.m_128445_(TAG_SIZE) & 0xFF) != this.modules.length) {
            this.modules = Arrays.copyOf(this.modules, newSize);
        }
        for (MeltingModule module : this.modules) {
            if (module == null) continue;
            module.setStack(ItemStack.f_41583_);
        }
        ListTag list = nbt.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            int slot;
            CompoundTag item = list.m_128728_(i);
            if (!item.m_128425_(TAG_SLOT, 1) || !this.validSlot(slot = item.m_128445_(TAG_SLOT) & 0xFF)) continue;
            this.getModule(slot).readFromTag(item);
        }
    }

    public void trackInts(Consumer<ContainerData> consumer) {
        for (int i = 0; i < this.getSlots(); ++i) {
            consumer.accept(this.getModule(i));
        }
    }
}

