/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.shared.command.HeldModifiableItemIterator;
import slimeknights.tconstruct.shared.command.argument.ToolStatArgument;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.StatOverrideModifier;

public class StatsCommand {
    private static final String SUCCESS_KEY_PREFIX = TConstruct.makeTranslationKey("command", "stats.success.");
    private static final String RESET_ALL_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.single");
    private static final String RESET_ALL_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.all.multiple");
    private static final String RESET_STAT_SINGLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.single");
    private static final String RESET_STAT_MULTIPLE = TConstruct.makeTranslationKey("command", "stats.success.reset.stat.multiple");
    private static final SimpleCommandExceptionType INVALID_ADD = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_add"));
    private static final SimpleCommandExceptionType INVALID_MULTIPLY = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "stats.failure.invalid_multiply"));
    private static final Dynamic2CommandExceptionType FAILED_TO_PARSE = new Dynamic2CommandExceptionType((stat, tag) -> TConstruct.makeTranslation("command", "stats.success.bonus.set.parse_fail", stat, tag));
    private static final DynamicCommandExceptionType MODIFIER_ERROR = new DynamicCommandExceptionType(error -> (Component)error);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"bonus").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"stat_type", ToolStatArgument.stat(INumericToolStat.class)).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> StatsCommand.update((CommandContext<CommandSourceStack>)context, Type.BONUS, Operation.MODIFY)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"stat_type", ToolStatArgument.stat()).then(Commands.m_82129_((String)"value", (ArgumentType)NbtTagArgument.m_100659_()).executes(context -> StatsCommand.update((CommandContext<CommandSourceStack>)context, Type.BONUS, Operation.SET))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"multiplier").then(Commands.m_82127_((String)"multiply").then(Commands.m_82129_((String)"float_stat", ToolStatArgument.stat(INumericToolStat.class)).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<CommandSourceStack>)context, Type.MULTIPLY, Operation.MODIFY)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"float_stat", ToolStatArgument.stat(INumericToolStat.class)).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> StatsCommand.update((CommandContext<CommandSourceStack>)context, Type.MULTIPLY, Operation.SET))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(StatsCommand::resetAll)).then(Commands.m_82129_((String)"stat_type", ToolStatArgument.stat()).executes(StatsCommand::resetStat))));
    }

    private static List<LivingEntity> updateEntities(CommandContext<CommandSourceStack> context, BiPredicate<IToolStackView, StatOverrideModifier> updateAction) throws CommandSyntaxException {
        return HeldModifiableItemIterator.apply(context, (living, stack) -> {
            boolean hasModifier;
            ToolStack tool = ToolStack.copyFrom(stack);
            StatOverrideModifier stats = (StatOverrideModifier)TinkerModifiers.statOverride.get();
            boolean needsModifier = updateAction.test(tool, stats);
            int level = tool.getUpgrades().getLevel(stats.getId());
            boolean bl = hasModifier = level > 0;
            if (needsModifier && !hasModifier) {
                tool.addModifier(stats.getId(), 1);
            } else if (hasModifier && !needsModifier) {
                tool.removeModifier(stats.getId(), level);
            } else {
                tool.rebuildStats();
            }
            ValidatedResult validated = tool.validate();
            if (validated.hasError()) {
                throw MODIFIER_ERROR.create((Object)validated.getMessage());
            }
            living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            return true;
        });
    }

    private static <T> List<LivingEntity> setStat(CommandContext<CommandSourceStack> context, IToolStat<T> stat, Tag tag) throws CommandSyntaxException {
        Object value = stat.read(tag);
        if (value == null) {
            throw FAILED_TO_PARSE.create((Object)stat.getPrefix(), (Object)tag);
        }
        return StatsCommand.updateEntities(context, (tool, stats) -> stats.set((IToolStackView)tool, stat, value));
    }

    private static int update(CommandContext<CommandSourceStack> context, Type type, Operation op) throws CommandSyntaxException {
        Object display;
        List<LivingEntity> successes;
        IToolStat<?> stat = ToolStatArgument.getStat(context, type.stat);
        if (op == Operation.SET && type == Type.BONUS) {
            Tag tag = NbtTagArgument.m_100662_(context, (String)"value");
            successes = StatsCommand.setStat(context, stat, tag);
            display = tag;
        } else {
            float value = FloatArgumentType.getFloat(context, (String)"value");
            if (op == Operation.MODIFY) {
                if (value == 0.0f && type == Type.BONUS) {
                    throw INVALID_ADD.create();
                }
                if (value == 1.0f && type == Type.MULTIPLY) {
                    throw INVALID_MULTIPLY.create();
                }
            }
            INumericToolStat numeric = (INumericToolStat)stat;
            successes = type == Type.BONUS ? StatsCommand.updateEntities(context, (tool, stats) -> stats.addBonus((IToolStackView)tool, numeric, value)) : (op == Operation.SET ? StatsCommand.updateEntities(context, (tool, stats) -> stats.setMultiplier((IToolStackView)tool, numeric, value)) : StatsCommand.updateEntities(context, (tool, stats) -> stats.multiply((IToolStackView)tool, numeric, value)));
            display = Float.valueOf(value);
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        String successKey = SUCCESS_KEY_PREFIX + type.key + "." + op.key + ".";
        if (size == 1) {
            source.m_81354_((Component)new TranslatableComponent(successKey + "single", new Object[]{stat.getPrefix(), display, successes.get(0).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent(successKey + "multiple", new Object[]{stat.getPrefix(), display, size}), true);
        }
        return size;
    }

    private static int resetStat(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        IToolStat<?> stat = ToolStatArgument.getStat(context, "stat_type");
        List<LivingEntity> successes = StatsCommand.updateEntities(context, (tool, stats) -> {
            if (stat instanceof INumericToolStat) {
                INumericToolStat numeric = (INumericToolStat)stat;
                stats.setMultiplier((IToolStackView)tool, numeric, 1.0f);
            }
            return stats.remove((IToolStackView)tool, stat);
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.m_81354_((Component)new TranslatableComponent(RESET_STAT_SINGLE, new Object[]{stat.getPrefix(), successes.get(0).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent(RESET_STAT_MULTIPLE, new Object[]{stat.getPrefix(), size}), true);
        }
        return size;
    }

    private static int resetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List<LivingEntity> successes = HeldModifiableItemIterator.apply(context, (living, stack) -> {
            StatOverrideModifier stats;
            ToolStack tool = ToolStack.from(stack);
            int level = tool.getModifierLevel(stats = (StatOverrideModifier)TinkerModifiers.statOverride.get());
            if (level > 0) {
                tool = tool.copy();
                tool.removeModifier(stats.getId(), level);
                Component error = tool.tryValidate();
                if (error != null) {
                    throw MODIFIER_ERROR.create((Object)error);
                }
                error = stats.getHook(TinkerHooks.REMOVE).onRemoved(tool, stats);
                if (error != null) {
                    throw MODIFIER_ERROR.create((Object)error);
                }
                living.m_21008_(InteractionHand.MAIN_HAND, tool.createStack(stack.m_41613_()));
            }
            return true;
        });
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int size = successes.size();
        if (size == 1) {
            source.m_81354_((Component)new TranslatableComponent(RESET_ALL_SINGLE, new Object[]{successes.get(0).m_5446_()}), true);
        } else {
            source.m_81354_((Component)new TranslatableComponent(RESET_ALL_MULTIPLE, new Object[]{size}), true);
        }
        return size;
    }

    private static enum Type {
        BONUS("stat_type"),
        MULTIPLY("float_stat");

        private final String key = this.name().toLowerCase(Locale.US);
        private final String stat;

        private Type(String stat) {
            this.stat = stat;
        }
    }

    private static enum Operation {
        MODIFY,
        SET;

        private final String key = this.name().toLowerCase(Locale.US);
    }
}

