/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.TablePrinter;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.shared.command.argument.ModifierHookArgument;

public class ModifierPriorityCommand {
    private static final Component SUCCESS = new TranslatableComponent("command.tconstruct.modifier_priority");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).executes(context -> ModifierPriorityCommand.run((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82129_((String)"modifier_hook", (ArgumentType)ModifierHookArgument.modifierHook()).executes(context -> ModifierPriorityCommand.run((CommandContext<CommandSourceStack>)context, true)));
    }

    private static int run(CommandContext<CommandSourceStack> context, boolean filtered) {
        TablePrinter table = new TablePrinter();
        table.header("ID", m -> m.getId().toString());
        table.header("Priority", m -> Integer.toString(m.getPriority()));
        Stream<Modifier> modifiers = ModifierManager.INSTANCE.getAllValues();
        StringBuilder builder = new StringBuilder();
        builder.append("Modifier Priorities");
        if (filtered) {
            ModifierHook<?> filter = ModifierHookArgument.getModifier(context, "modifier_hook");
            modifiers = modifiers.filter(m -> m.getHooks().hasHook(filter));
            builder.append(" for ").append(filter.getName());
        } else {
            table.header("Hooks", m -> m.getHooks().getAllModules().keySet().stream().map(ModifierHook::getName).sorted().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
        builder.append(":").append(System.lineSeparator());
        List<Modifier> list = modifiers.sorted(Comparator.comparingInt(Modifier::getPriority).reversed().thenComparing(Modifier::getId)).toList();
        table.add(list);
        table.build(builder);
        TConstruct.LOG.info(builder.toString());
        ((CommandSourceStack)context.getSource()).m_81354_(SUCCESS, true);
        return list.size();
    }
}

