/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;
import slimeknights.mantle.data.ISafeManagerReloadListener;

public class DomainDisplayName {
    private static final Map<String, String> DISPLAY_NAME_LOOKUP = new HashMap<String, String>();
    private static final Pattern DASH_UNDERSCORE = Pattern.compile("[_-]");
    private static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> DISPLAY_NAME_LOOKUP.clear();

    private DomainDisplayName() {
    }

    private static String formatDomainName(String domain) {
        return WordUtils.capitalize((String)DASH_UNDERSCORE.matcher(domain).replaceAll(" "));
    }

    private static String nameForUncached(String domain) {
        String langKey = "domain." + domain + ".display_name";
        String translated = ForgeI18n.getPattern((String)langKey);
        if (!translated.equals(langKey)) {
            return translated;
        }
        return ModList.get().getModContainerById(domain).map(container -> container.getModInfo().getDisplayName()).orElseGet(() -> DomainDisplayName.formatDomainName(domain));
    }

    public static String nameFor(String domain) {
        return DISPLAY_NAME_LOOKUP.computeIfAbsent(domain, DomainDisplayName::nameForUncached);
    }

    public static void addResourceListener(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)RELOAD_LISTENER);
    }
}

