/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends Item
implements IMaterialItem {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(Item.Properties properties) {
        super(properties);
    }

    private static MaterialVariantId getMaterialId(@Nullable CompoundTag nbt) {
        MaterialVariantId id;
        String str;
        if (nbt != null && !(str = nbt.m_128461_("Material")).isEmpty() && (id = MaterialVariantId.tryParse(str)) != null) {
            return id;
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Override
    public MaterialVariantId getMaterial(ItemStack stack) {
        return MaterialItem.getMaterialId(stack.m_41783_());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group) && MaterialRegistry.isFullyLoaded()) {
            MaterialVariantId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialVariantId.tryParse(showOnlyId)) != null && this.canUseMaterial(materialId.getId())) {
                items.add((Object)this.withMaterialForDisplay(materialId));
                added = true;
            }
            if (!added) {
                for (IMaterial material : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    MaterialId id = material.getIdentifier();
                    if (!this.canUseMaterial(id)) continue;
                    items.add((Object)this.withMaterial(id));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    @Nullable
    private static Component getName(String baseKey, MaterialVariantId material) {
        ResourceLocation location = material.getLocation('.');
        String fullKey = String.format("%s.%s.%s", baseKey, location.m_135827_(), location.m_135815_());
        if (Util.canTranslate(fullKey)) {
            return new TranslatableComponent(fullKey);
        }
        String materialKey = MaterialTooltipCache.getKey(material);
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return new TranslatableComponent(materialPrefix, new Object[]{new TranslatableComponent(baseKey)});
        }
        if (Util.canTranslate(materialKey)) {
            return new TranslatableComponent(TooltipUtil.KEY_FORMAT, new Object[]{new TranslatableComponent(materialKey), new TranslatableComponent(baseKey)});
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        Component component;
        MaterialVariantId material = this.getMaterial(stack);
        if (material.equals(IMaterial.UNKNOWN_ID)) {
            return super.m_7626_(stack);
        }
        String key = this.m_5671_(stack);
        if (material.hasVariant() && (component = MaterialItem.getName(key, material)) != null) {
            return component;
        }
        component = MaterialItem.getName(key, material.getId());
        if (component != null) {
            return component;
        }
        return new TranslatableComponent(key);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        MaterialVariantId material = this.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            return material.getId().m_135827_();
        }
        ResourceLocation id = this.getRegistryName();
        return id == null ? null : id.m_135827_();
    }

    protected static void addModTooltip(IMaterial material, List<Component> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TranslatableComponent(ADDED_BY, new Object[]{DomainDisplayName.nameFor(material.getIdentifier().m_135827_())}));
        }
    }

    public void m_142312_(CompoundTag nbt) {
        MaterialId resolved;
        MaterialId original;
        MaterialVariantId id = MaterialItem.getMaterialId(nbt);
        if (!id.equals(IMaterial.UNKNOWN_ID) && (original = id.getId()) != (resolved = MaterialRegistry.getInstance().resolve(original))) {
            nbt.m_128359_("Material", MaterialVariantId.create(resolved, id.getVariant()).toString());
        }
    }
}

