/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class ToolBuildingRecipeSerializer
extends LoggingRecipeSerializer<ToolBuildingRecipe> {
    public ToolBuildingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        IModifiable item = (IModifiable)RecipeHelper.deserializeItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (String)"result", IModifiable.class);
        int resultCount = GsonHelper.m_13824_((JsonObject)json, (String)"result_count", (int)1);
        List extraRequirements = Collections.emptyList();
        if (json.has("extra_requirements")) {
            extraRequirements = JsonHelper.parseList((JsonObject)json, (String)"extra_requirements", Ingredient::m_43917_);
        }
        if (!item.getToolDefinition().isMultipart() && extraRequirements.isEmpty()) {
            throw new JsonSyntaxException("Modifiable item must have tool parts or extra requirements to use tool building recipes");
        }
        return new ToolBuildingRecipe(recipeId, group, item, resultCount, extraRequirements);
    }

    @Nullable
    protected ToolBuildingRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130136_(Short.MAX_VALUE);
        IModifiable result = (IModifiable)RecipeHelper.readItem((FriendlyByteBuf)buffer, IModifiable.class);
        int resultSize = buffer.m_130242_();
        int size = buffer.m_130242_();
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return new ToolBuildingRecipe(recipeId, group, result, resultSize, (List<Ingredient>)ingredients.build());
    }

    protected void toNetworkSafe(FriendlyByteBuf buffer, ToolBuildingRecipe recipe) {
        buffer.m_130070_(recipe.group);
        RecipeHelper.writeItem((FriendlyByteBuf)buffer, (ItemLike)recipe.output);
        buffer.m_130130_(recipe.outputCount);
        buffer.m_130130_(recipe.ingredients.size());
        for (Ingredient ingredient : recipe.ingredients) {
            ingredient.m_43923_(buffer);
        }
    }
}

