/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.NamedComponentRegistry;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipe
extends ModifierRecipe {
    private static final String ALREADY_PRESENT = TConstruct.makeTranslationKey("recipe", "swappable.already_present");
    private final String value;
    private final VariantFormatter variantFormatter;
    private final Component variant;

    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, VariantFormatter variantFormatter, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, new ModifierEntry(result, 1), 1, slots, allowCrystal);
        this.value = value;
        this.variantFormatter = variantFormatter;
        this.variant = variantFormatter.format(result, value);
    }

    @Deprecated
    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        this(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, result, value, VariantFormatter.NONE, slots, allowCrystal);
    }

    @Deprecated
    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, String value, @Nullable SlotType.SlotCount slots) {
        this(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, result, value, slots, false);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        ValidatedResult commonError;
        boolean needsModifier;
        ToolStack tool = inv.getTinkerable();
        ModifierId modifier = this.result.getId();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            commonError = this.validatePrerequisites(tool);
        } else {
            needsModifier = false;
            commonError = this.validateRequirements(tool);
        }
        if (commonError.hasError()) {
            return commonError;
        }
        if (tool.getPersistentData().getString(modifier).equals(this.value)) {
            return ValidatedResult.failure(ALREADY_PRESENT, this.result.getModifier().getDisplayName(), this.variant);
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        persistentData.putString(modifier, this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getId(), 1);
        } else {
            tool.rebuildStats();
        }
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())));
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierId id = this.result.getId();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result, data -> data.putString(id, this.value))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public Component getVariant() {
        return this.variant;
    }

    @FunctionalInterface
    public static interface VariantFormatter {
        public static final NamedComponentRegistry<VariantFormatter> LOADER = new NamedComponentRegistry("Unknown variant formatter");
        @Deprecated
        public static final VariantFormatter NONE = (VariantFormatter)LOADER.register(TConstruct.getResource("none"), (modifier, variant) -> new TextComponent(variant));
        public static final VariantFormatter DEFAULT = (VariantFormatter)LOADER.register(TConstruct.getResource("default"), (modifier, variant) -> new TranslatableComponent(Util.makeTranslationKey("modifier", modifier) + "." + variant));
        public static final VariantFormatter MATERIAL = (VariantFormatter)LOADER.register(TConstruct.getResource("material"), (modifier, variant) -> MaterialTooltipCache.getDisplayName(Objects.requireNonNullElse(MaterialVariantId.tryParse(variant), IMaterial.UNKNOWN_ID)));

        public Component format(ModifierId var1, String var2);
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<SwappableModifierRecipe> {
        @Override
        protected ModifierEntry readResult(JsonObject json) {
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            return new ModifierEntry(ModifierId.getFromJson(result, "name"), 1);
        }

        @Override
        public SwappableModifierRecipe fromJson(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            String value = GsonHelper.m_13906_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (String)"value");
            boolean allowCrystal = GsonHelper.m_13855_((JsonObject)json, (String)"allow_crystal", (boolean)false);
            VariantFormatter variantFormatter = (VariantFormatter)VariantFormatter.LOADER.deserialize(json, "variant_formatter");
            return new SwappableModifierRecipe(id, ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, variantFormatter, slots, allowCrystal);
        }

        @Override
        public SwappableModifierRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            String value = buffer.m_130277_();
            boolean allowCrystal = buffer.readBoolean();
            VariantFormatter variantFormatter = (VariantFormatter)VariantFormatter.LOADER.fromNetwork(buffer);
            return new SwappableModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result.getId(), value, variantFormatter, slots, allowCrystal);
        }

        @Override
        protected void toNetworkSafe(FriendlyByteBuf buffer, SwappableModifierRecipe recipe) {
            super.toNetworkSafe(buffer, recipe);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.m_130070_(recipe.value);
            buffer.writeBoolean(recipe.allowCrystal);
            VariantFormatter.LOADER.toNetwork((Object)recipe.variantFormatter, buffer);
        }
    }
}

