/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.mining;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedFormula;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ConditionalStatTooltip;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalMiningSpeedModule(IJsonPredicate<BlockState> block, IJsonPredicate<LivingEntity> holder, boolean requireEffective, MiningSpeedFormula formula, boolean percent, ModifierModuleCondition condition) implements BreakSpeedModifierHook,
ConditionalStatTooltip,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.BREAK_SPEED, TinkerHooks.TOOLTIP);
    public static final GenericLoaderRegistry.IGenericLoader<ConditionalMiningSpeedModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ConditionalMiningSpeedModule>(){

        public ConditionalMiningSpeedModule deserialize(JsonObject json) {
            boolean percent = GsonHelper.m_13855_((JsonObject)json, (String)"percent", (boolean)false);
            return new ConditionalMiningSpeedModule((IJsonPredicate<BlockState>)((IJsonPredicate)BlockPredicate.LOADER.getAndDeserialize(json, "blocks")), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "entity")), GsonHelper.m_13855_((JsonObject)json, (String)"require_effective", (boolean)true), MiningSpeedFormula.deserialize(json, percent), percent, ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ConditionalMiningSpeedModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("blocks", BlockPredicate.LOADER.serialize(object.block));
            json.add("entity", LivingEntityPredicate.LOADER.serialize(object.holder));
            json.addProperty("require_effective", Boolean.valueOf(object.requireEffective));
            json.addProperty("percent", Boolean.valueOf(object.percent));
            object.formula.serialize(json);
        }

        public ConditionalMiningSpeedModule fromNetwork(FriendlyByteBuf buffer) {
            boolean percent = buffer.readBoolean();
            return new ConditionalMiningSpeedModule((IJsonPredicate<BlockState>)((IJsonPredicate)BlockPredicate.LOADER.fromNetwork(buffer)), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), buffer.readBoolean(), MiningSpeedFormula.fromNetwork(buffer, percent), percent, ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ConditionalMiningSpeedModule object, FriendlyByteBuf buffer) {
            buffer.writeBoolean(object.percent);
            BlockPredicate.LOADER.toNetwork(object.block, buffer);
            LivingEntityPredicate.LOADER.toNetwork(object.holder, buffer);
            buffer.writeBoolean(object.requireEffective);
            object.formula.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent ? Integer.valueOf(75) : null;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        if ((isEffective || !this.requireEffective) && this.condition.matches(tool, modifier) && this.block.matches((Object)event.getState()) && this.holder.matches((Object)player)) {
            event.setNewSpeed(this.formula.apply(tool, modifier, event, player, sideHit, event.getOriginalSpeed(), event.getNewSpeed(), miningSpeedModifier));
        }
    }

    @Override
    public INumericToolStat<?> stat() {
        return ToolStats.MINING_SPEED;
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool, entry, null, player, null, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalMiningSpeedModule, MiningSpeedVariable> {
        private IJsonPredicate<BlockState> blocks = BlockPredicate.ANY;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private boolean percent = false;
        private boolean requireEffective = true;

        private Builder() {
            super(MiningSpeedFormula.VARIABLES);
        }

        public Builder percent() {
            this.percent = true;
            return this;
        }

        public Builder allowIneffective() {
            this.requireEffective = false;
            return this;
        }

        @Override
        protected ConditionalMiningSpeedModule build(ModifierFormula formula) {
            return new ConditionalMiningSpeedModule(this.blocks, this.holder, this.requireEffective, new MiningSpeedFormula(formula, this.variables), this.percent, this.condition);
        }

        public Builder blocks(IJsonPredicate<BlockState> blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }
    }
}

