/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record KnockbackModule(IJsonPredicate<LivingEntity> entity, ModifierFormula formula, ModifierModuleCondition condition) implements MeleeHitModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.MELEE_HIT);
    private static final String[] VARIABLES = new String[]{"level", "knockback"};
    private static final ModifierFormula.FallbackFormula FALLBACK_FORMULA = ModifierFormula.FallbackFormula.ADD;
    public static final GenericLoaderRegistry.IGenericLoader<KnockbackModule> LOADER = new GenericLoaderRegistry.IGenericLoader<KnockbackModule>(){

        public KnockbackModule deserialize(JsonObject json) {
            return new KnockbackModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "entity")), ModifierFormula.deserialize(json, VARIABLES, FALLBACK_FORMULA), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(KnockbackModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("entity", LivingEntityPredicate.LOADER.serialize(object.entity));
            object.formula.serialize(json, VARIABLES);
        }

        public KnockbackModule fromNetwork(FriendlyByteBuf buffer) {
            return new KnockbackModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), ModifierFormula.fromNetwork(buffer, VARIABLES.length, FALLBACK_FORMULA), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(KnockbackModule object, FriendlyByteBuf buffer) {
            LivingEntityPredicate.LOADER.toNetwork(object.entity, buffer);
            object.formula.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity target;
        if (this.condition.matches(tool, modifier) && ((target = context.getLivingTarget()) == null ? this.entity == LivingEntityPredicate.ANY : this.entity.matches((Object)target))) {
            return this.formula.apply(this.formula.computeLevel(tool, modifier), knockback);
        }
        return knockback;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModifierFormula.Builder<Builder, KnockbackModule> {
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;

        private Builder() {
            super(VARIABLES);
        }

        @Override
        protected KnockbackModule build(ModifierFormula formula) {
            return new KnockbackModule(this.entity, formula, this.condition);
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }
    }
}

