/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.melee.MeleeFormula;
import slimeknights.tconstruct.library.json.variable.melee.MeleeVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ConditionalStatTooltip;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalMeleeDamageModule(IJsonPredicate<LivingEntity> target, IJsonPredicate<LivingEntity> attacker, MeleeFormula formula, boolean percent, ModifierModuleCondition condition) implements MeleeDamageModifierHook,
ConditionalStatTooltip,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.MELEE_DAMAGE, TinkerHooks.TOOLTIP);
    public static final GenericLoaderRegistry.IGenericLoader<ConditionalMeleeDamageModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ConditionalMeleeDamageModule>(){

        public ConditionalMeleeDamageModule deserialize(JsonObject json) {
            boolean percent = GsonHelper.m_13855_((JsonObject)json, (String)"percent", (boolean)false);
            return new ConditionalMeleeDamageModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "target")), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "attacker")), MeleeFormula.deserialize(json, percent), percent, ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ConditionalMeleeDamageModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("target", LivingEntityPredicate.LOADER.serialize(object.target));
            json.add("attacker", LivingEntityPredicate.LOADER.serialize(object.attacker));
            json.addProperty("percent", Boolean.valueOf(object.percent));
            object.formula.serialize(json);
        }

        public ConditionalMeleeDamageModule fromNetwork(FriendlyByteBuf buffer) {
            boolean percent = buffer.readBoolean();
            return new ConditionalMeleeDamageModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), MeleeFormula.fromNetwork(buffer, percent), percent, ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ConditionalMeleeDamageModule object, FriendlyByteBuf buffer) {
            buffer.writeBoolean(object.percent);
            LivingEntityPredicate.LOADER.toNetwork(object.target, buffer);
            LivingEntityPredicate.LOADER.toNetwork(object.attacker, buffer);
            object.formula.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent ? Integer.valueOf(75) : null;
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target;
        if (this.condition.matches(tool, modifier) && this.attacker.matches((Object)context.getAttacker()) && (target = context.getLivingTarget()) != null && this.target.matches((Object)target)) {
            damage = this.formula.apply(tool, modifier, context, context.getAttacker(), baseDamage, damage);
        }
        return damage;
    }

    @Override
    public IJsonPredicate<LivingEntity> holder() {
        return this.attacker;
    }

    @Override
    public INumericToolStat<?> stat() {
        return ToolStats.ATTACK_DAMAGE;
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool, entry, null, (LivingEntity)player, 1.0f, 1.0f);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalMeleeDamageModule, MeleeVariable> {
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;
        private boolean percent = false;

        private Builder() {
            super(MeleeFormula.VARIABLES);
        }

        public Builder percent() {
            this.percent = true;
            return this;
        }

        @Override
        protected ConditionalMeleeDamageModule build(ModifierFormula formula) {
            return new ConditionalMeleeDamageModule(this.target, this.attacker, new MeleeFormula(formula, this.variables), this.percent, this.condition);
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }
    }
}

