/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public interface EnchantmentModule
extends ModifierModule {
    public Enchantment enchantment();

    public int level();

    public ModifierModuleCondition condition();

    public static Builder constant(Enchantment enchantment) {
        return new Builder(Constant::new, enchantment);
    }

    public static Builder harvest(Enchantment enchantment) {
        return new Builder(Harvest::new, enchantment);
    }

    private static void removeEnchantment(ListTag list, Enchantment enchantment) {
        String id = Objects.requireNonNull(enchantment.getRegistryName()).toString();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CompoundTag enchantmentTag;
            Tag iteratorTag = (Tag)iterator.next();
            if (iteratorTag.m_7060_() != 10 || !id.equals((enchantmentTag = (CompoundTag)iteratorTag).m_128461_("id"))) continue;
            iterator.remove();
        }
    }

    public static void setEnchantmentLevel(RestrictedCompoundTag tag, Enchantment enchantment, int level) {
        ListTag enchantments;
        if (tag.contains("Enchantments", 9)) {
            enchantments = tag.getList("Enchantments", 10);
            EnchantmentModule.removeEnchantment(enchantments, enchantment);
        } else {
            enchantments = new ListTag();
            tag.put("Enchantments", (Tag)enchantments);
        }
        enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)enchantment.getRegistryName(), (int)level));
    }

    public static void removeEnchantment(RestrictedCompoundTag tag, Enchantment enchantment) {
        if (tag.contains("Enchantments", 9)) {
            ListTag enchantments = tag.getList("Enchantments", 10);
            EnchantmentModule.removeEnchantment(enchantments, enchantment);
            if (enchantments.isEmpty()) {
                tag.remove("Enchantments");
            }
        }
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final EnchantmentModuleConstructor constructor;
        private final Enchantment enchantment;
        private int level = 1;

        public EnchantmentModule build() {
            return this.constructor.apply(this.enchantment, this.level, this.condition);
        }

        private Builder(EnchantmentModuleConstructor constructor, Enchantment enchantment) {
            this.constructor = constructor;
            this.enchantment = enchantment;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }
    }

    @FunctionalInterface
    public static interface EnchantmentModuleConstructor {
        public EnchantmentModule apply(Enchantment var1, int var2, ModifierModuleCondition var3);
    }

    public record Constant(Enchantment enchantment, int level, ModifierModuleCondition condition) implements EnchantmentModule,
    RawDataModifierHook
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.RAW_DATA);
        public static final Loader LOADER = new Loader(Constant::new);

        @Override
        public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
            int level;
            if (this.condition.matches(tool, modifier) && (level = Mth.m_14143_((float)((float)this.level * modifier.getEffectiveLevel(tool)))) > 0) {
                EnchantmentModule.setEnchantmentLevel(tag, this.enchantment, level);
                return;
            }
            EnchantmentModule.removeEnchantment(tag, this.enchantment);
        }

        @Override
        public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
            EnchantmentModule.removeEnchantment(tag, this.enchantment);
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public record Harvest(Enchantment enchantment, int level, ModifierModuleCondition condition) implements EnchantmentModule,
    HarvestEnchantmentsModifierHook
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_HARVEST_ENCHANTMENTS, TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS);
        public static final Loader LOADER = new Loader(Harvest::new);

        @Override
        public void applyHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, BiConsumer<Enchantment, Integer> consumer) {
            int level;
            if (this.condition.matches(tool, modifier) && (level = Mth.m_14143_((float)(modifier.getEffectiveLevel(tool) * (float)this.level))) > 0) {
                consumer.accept(this.enchantment, level);
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public record Loader(EnchantmentModuleConstructor constructor) implements GenericLoaderRegistry.IGenericLoader<EnchantmentModule>
    {
        public EnchantmentModule deserialize(JsonObject json) {
            return this.constructor.apply((Enchantment)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (JsonObject)json, (String)"name"), JsonUtils.getIntMin(json, "level", 1), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(EnchantmentModule object, JsonObject json) {
            object.condition().serializeInto(json);
            json.addProperty("name", Objects.requireNonNull(object.enchantment().getRegistryName()).toString());
            json.addProperty("level", (Number)object.level());
        }

        public EnchantmentModule fromNetwork(FriendlyByteBuf buffer) {
            return this.constructor.apply((Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS), buffer.m_130242_(), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(EnchantmentModule object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (IForgeRegistryEntry)object.enchantment());
            buffer.m_130130_(object.level());
            object.condition().toNetwork(buffer);
        }
    }
}

