/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.behavior.BlockTransformModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ToolActionTransformModule(ToolAction action, SoundEvent sound, boolean requireGround, int eventId, ModifierModuleCondition condition) implements BlockTransformModule,
ToolActionModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.BLOCK_INTERACT, TinkerHooks.TOOL_ACTION);
    public static final GenericLoaderRegistry.IGenericLoader<ToolActionTransformModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolActionTransformModule>(){

        public ToolActionTransformModule deserialize(JsonObject json) {
            return new ToolActionTransformModule(ToolAction.get((String)GsonHelper.m_13906_((JsonObject)json, (String)"tool_action")), (SoundEvent)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (JsonObject)json, (String)"sound"), GsonHelper.m_13912_((JsonObject)json, (String)"require_ground"), GsonHelper.m_13824_((JsonObject)json, (String)"event_id", (int)-1), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ToolActionTransformModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("tool_action", object.action.name());
            json.addProperty("sound", Objects.requireNonNull(object.sound.getRegistryName()).toString());
            json.addProperty("require_ground", Boolean.valueOf(object.requireGround));
            if (object.eventId != -1) {
                json.addProperty("event_id", (Number)object.eventId);
            }
        }

        public ToolActionTransformModule fromNetwork(FriendlyByteBuf buffer) {
            return new ToolActionTransformModule(ToolAction.get((String)buffer.m_130136_(Short.MAX_VALUE)), (SoundEvent)buffer.readRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS), buffer.readBoolean(), buffer.readShort(), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ToolActionTransformModule object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.action.name());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS, (IForgeRegistryEntry)object.sound);
            buffer.writeBoolean(object.requireGround);
            buffer.writeShort(object.eventId);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && this.action == toolAction;
    }

    @Override
    public boolean transform(IToolStackView tool, UseOnContext context, BlockState original, boolean playSound) {
        Material material;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos above = pos.m_7494_();
        if (this.requireGround && !(material = level.m_8055_(above).m_60767_()).m_76336_() && material != Material.f_76300_) {
            return false;
        }
        Player player = context.m_43723_();
        BlockState transformed = original.getToolModifiedState(context, this.action, false);
        if (transformed != null) {
            if (playSound) {
                level.m_5594_(player, pos, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.eventId != -1) {
                    level.m_5898_(player, this.eventId, pos, 0);
                }
            }
            if (!level.f_46443_) {
                level.m_7731_(pos, transformed, 11);
                if (this.requireGround) {
                    level.m_46961_(above, true);
                }
                BlockTransformModifierHook.afterTransformBlock(tool, context, original, pos, this.action);
            }
            return true;
        }
        return false;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(ToolAction action, SoundEvent sound) {
        return new Builder(action, sound);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final ToolAction action;
        private final SoundEvent sound;
        private boolean requireGround;
        private int eventId = -1;

        public Builder requireGround() {
            this.requireGround = true;
            return this;
        }

        public ToolActionTransformModule build() {
            return new ToolActionTransformModule(this.action, this.sound, this.requireGround, this.eventId, this.condition);
        }

        private Builder(ToolAction action, SoundEvent sound) {
            this.action = action;
            this.sound = sound;
        }

        public Builder eventId(int eventId) {
            this.eventId = eventId;
            return this;
        }
    }
}

