/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EffectiveLevelModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.ModuleWithKey;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record IncrementalModule(@Nullable ResourceLocation key, int neededPerLevel) implements EffectiveLevelModifierHook,
DisplayNameModifierHook,
ModifierRemovalHook,
ModifierModule,
ModuleWithKey
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.EFFECTIVE_LEVEL, TinkerHooks.DISPLAY_NAME, TinkerHooks.REMOVE);
    public static IncrementalModule RECIPE_CONTROLLED = new IncrementalModule(null, 0);
    public static final GenericLoaderRegistry.IGenericLoader<IncrementalModule> LOADER = new GenericLoaderRegistry.IGenericLoader<IncrementalModule>(){

        public IncrementalModule deserialize(JsonObject json) {
            ResourceLocation key = ModuleWithKey.parseKey(json);
            int neededPerLevel = JsonUtils.getIntMin(json, "needed_per_level", 0);
            return IncrementalModule.create(key, neededPerLevel);
        }

        public void serialize(IncrementalModule object, JsonObject json) {
            if (object.key != null) {
                json.addProperty("key", object.key.toString());
            }
            if (object.neededPerLevel > 0) {
                json.addProperty("needed_per_level", (Number)object.neededPerLevel);
            }
        }

        public IncrementalModule fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation key = ModuleWithKey.fromNetwork(buffer);
            int neededPerLevel = buffer.m_130242_();
            return IncrementalModule.create(key, neededPerLevel);
        }

        public void toNetwork(IncrementalModule object, FriendlyByteBuf buffer) {
            ModuleWithKey.toNetwork(object.key, buffer);
            buffer.m_130130_(object.neededPerLevel);
        }
    };

    public static IncrementalModule create(@Nullable ResourceLocation key, int neededPerLevel) {
        if (key == null && neededPerLevel == 0) {
            return RECIPE_CONTROLLED;
        }
        return new IncrementalModule(key, neededPerLevel);
    }

    private int getNeededPerLevel(ResourceLocation key) {
        if (this.neededPerLevel > 0) {
            return this.neededPerLevel;
        }
        return ModifierRecipeLookup.getNeededPerLevel(key);
    }

    private int getAmount(IToolContext tool, ResourceLocation key, int neededPerLevel) {
        IModDataView data = tool.getPersistentData();
        if (data.contains(key, 99)) {
            return data.getInt(key);
        }
        return neededPerLevel;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, Modifier modifier, int level, Component name) {
        ResourceLocation key = this.getKey(modifier);
        int neededPerLevel = this.getNeededPerLevel(key);
        if (neededPerLevel > 0) {
            return IncrementalModifier.addAmountToName(this.getAmount(tool, key, neededPerLevel), neededPerLevel, name);
        }
        return name;
    }

    @Override
    public float getEffectiveLevel(IToolContext tool, Modifier modifier, float level) {
        if (level <= 0.0f) {
            return 0.0f;
        }
        ResourceLocation key = this.getKey(modifier);
        int neededPerLevel = this.getNeededPerLevel(key);
        if (neededPerLevel > 0) {
            return IncrementalModifier.scaleLevel(level, this.getAmount(tool, key, neededPerLevel), neededPerLevel);
        }
        return level;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }
}

