/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ConditionalStatTooltip;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalStatModule(INumericToolStat<?> stat, IJsonPredicate<LivingEntity> holder, ConditionalStatFormula formula, boolean percent, ModifierModuleCondition condition) implements ModifierModule,
ConditionalStatModifierHook,
ConditionalStatTooltip
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.CONDITIONAL_STAT, TinkerHooks.TOOLTIP);
    public static final int VALUE = 1;
    public static final int MULTIPLIER = 2;
    public static final GenericLoaderRegistry.IGenericLoader<ConditionalStatModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ConditionalStatModule>(){

        public ConditionalStatModule deserialize(JsonObject json) {
            boolean percent = GsonHelper.m_13855_((JsonObject)json, (String)"percent", (boolean)false);
            return new ConditionalStatModule(ToolStats.numericFromJson(GsonHelper.m_13906_((JsonObject)json, (String)"stat")), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "entity")), ConditionalStatFormula.deserialize(json, percent), percent, ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ConditionalStatModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("stat", object.stat.getName().toString());
            json.add("entity", LivingEntityPredicate.LOADER.serialize(object.holder));
            json.addProperty("percent", Boolean.valueOf(object.percent));
            object.formula.serialize(json);
        }

        public ConditionalStatModule fromNetwork(FriendlyByteBuf buffer) {
            boolean percent = buffer.readBoolean();
            return new ConditionalStatModule(ToolStats.numericFromNetwork(buffer), (IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), ConditionalStatFormula.fromNetwork(buffer, percent), percent, ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ConditionalStatModule object, FriendlyByteBuf buffer) {
            buffer.writeBoolean(object.percent);
            buffer.m_130070_(object.stat.getName().toString());
            LivingEntityPredicate.LOADER.toNetwork(object.holder, buffer);
            object.formula.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent ? Integer.valueOf(75) : null;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (this.stat == stat && this.condition.matches(tool, modifier) && this.holder.matches((Object)living)) {
            return this.formula.apply(tool, modifier, living, baseValue, multiplier);
        }
        return baseValue;
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool, entry, (LivingEntity)player, 1.0f, 1.0f);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ConditionalStatModule> getLoader() {
        return LOADER;
    }

    public static Builder stat(INumericToolStat<?> stat) {
        return new Builder(stat);
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalStatModule, ConditionalStatVariable> {
        private final INumericToolStat<?> stat;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private boolean percent = false;

        private Builder(INumericToolStat<?> stat) {
            super(ConditionalStatFormula.VARIABLES);
            this.stat = stat;
        }

        public Builder percent() {
            this.percent = true;
            return this;
        }

        @Override
        protected ConditionalStatModule build(ModifierFormula formula) {
            return new ConditionalStatModule(this.stat, this.holder, new ConditionalStatFormula(formula, this.variables), this.percent, this.condition);
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }
    }
}

