/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.loader.RegistryEntryLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MobDisguiseModule(EntityType<?> entity) implements EquipmentChangeModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.EQUIPMENT_CHANGE);
    public static final GenericLoaderRegistry.IGenericLoader<MobDisguiseModule> LOADER = new RegistryEntryLoader("entity", ForgeRegistries.ENTITIES, MobDisguiseModule::new, MobDisguiseModule::entity);
    public static final TinkerDataCapability.ComputableDataKey<Multiset<EntityType<?>>> DISGUISES = TConstruct.createKey("mob_disguise", HashMultiset::create);

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> ((Multiset)data.computeIfAbsent(DISGUISES)).add(this.entity, modifier.getLevel()));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                Multiset<EntityType<?>> disguises = data.get(DISGUISES);
                if (disguises != null) {
                    disguises.remove(this.entity, modifier.getLevel());
                }
            });
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }
}

