/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.armor.ArmorWalkRadiusModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record CoverGroundWalkerModule(BlockState state, LevelingValue radius, ModifierModuleCondition condition) implements ModifierModule,
ArmorWalkRadiusModule<Void>
{
    public static final GenericLoaderRegistry.IGenericLoader<CoverGroundWalkerModule> LOADER = new GenericLoaderRegistry.IGenericLoader<CoverGroundWalkerModule>(){

        public CoverGroundWalkerModule deserialize(JsonObject json) {
            return new CoverGroundWalkerModule(JsonHelper.convertToBlockState((JsonObject)json), LevelingValue.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"radius")), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(CoverGroundWalkerModule object, JsonObject json) {
            object.condition.serializeInto(json);
            JsonHelper.serializeBlockState((BlockState)object.state, (JsonObject)json);
            json.add("radius", (JsonElement)object.radius.serialize(new JsonObject()));
        }

        public CoverGroundWalkerModule fromNetwork(FriendlyByteBuf buffer) {
            return new CoverGroundWalkerModule(Block.m_49803_((int)buffer.m_130242_()), LevelingValue.fromNetwork(buffer), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(CoverGroundWalkerModule object, FriendlyByteBuf buffer) {
            buffer.m_130130_(Block.m_49956_((BlockState)object.state));
            object.radius.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public float getRadius(IToolStackView tool, ModifierEntry modifier) {
        return this.radius.compute(modifier.getLevel() + tool.getModifierLevel(TinkerModifiers.expanded.getId()));
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (this.condition.matches(tool, modifier)) {
            ArmorWalkRadiusModule.super.onWalk(tool, modifier, living, prevPos, newPos);
        }
    }

    @Override
    public void walkOn(IToolStackView tool, ModifierEntry entry, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable, Void context) {
        if (world.m_46859_(target) && this.state.m_60710_((LevelReader)world, target)) {
            world.m_46597_(target, this.state);
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder state(BlockState state) {
        return new Builder(state);
    }

    public static Builder block(Block block) {
        return CoverGroundWalkerModule.state(block.m_49966_());
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder>
    implements LevelingValue.Builder<CoverGroundWalkerModule> {
        private final BlockState state;

        @Override
        public CoverGroundWalkerModule amount(float flat, float eachLevel) {
            return new CoverGroundWalkerModule(this.state, new LevelingValue(flat, eachLevel), this.condition);
        }

        private Builder(BlockState state) {
            this.state = state;
        }
    }
}

