/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankCapacityModule;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.TooltipKey;

@Deprecated
public class TankModifier
extends Modifier {
    private static final String FILLED_KEY = TConstruct.makeTranslationKey("modifier", "tank.filled");
    private static final String CAPACITY_KEY = TConstruct.makeTranslationKey("modifier", "tank.capacity");
    public static final BiFunction<CompoundTag, String, FluidStack> PARSE_FLUID = TankModule.PARSE_FLUID;
    private ModifierTank tank;
    private final int capacity;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        this.tank = new ModifierTank();
        hookBuilder.addHook(this.tank, ToolFluidCapability.HOOK);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ResourceLocation ownerKey = this.getOwnerKey();
        if (ownerKey != null && !volatileData.contains(ownerKey, 8)) {
            volatileData.putString(ownerKey, this.getId().toString());
        }
        ToolFluidCapability.addTanks(context, this, volatileData, this.tank);
        if (this.capacity > 0) {
            this.addCapacity(volatileData, this.capacity * level);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.isOwner(tool)) {
            FluidStack current = this.getFluid(tool);
            if (!current.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent(FILLED_KEY, new Object[]{current.getAmount(), current.getDisplayName()}));
            }
            tooltip.add((Component)new TranslatableComponent(CAPACITY_KEY, new Object[]{this.getCapacity(tool)}));
        }
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        FluidStack fluidStack;
        if (level > 0 && this.isOwner(tool) && !(fluidStack = this.getFluid(tool)).isEmpty()) {
            int capacity = this.getCapacity(tool);
            if (fluidStack.getAmount() > capacity) {
                fluidStack.setAmount(capacity);
                this.setFluid(tool, fluidStack);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!persistentData.contains(TankModule.DEFAULT_OWNER_KEY, 8)) {
            persistentData.remove(this.getFluidKey());
        }
    }

    @Nullable
    public ResourceLocation getOwnerKey() {
        return TankModule.DEFAULT_OWNER_KEY;
    }

    public ResourceLocation getCapacityKey() {
        return TankCapacityModule.DEFAULT_CAPACITY_KEY;
    }

    public ResourceLocation getFluidKey() {
        return TankModule.DEFAULT_FLUID_KEY;
    }

    public boolean isOwner(IModDataView volatileData) {
        ResourceLocation key = this.getOwnerKey();
        if (key == null) {
            return true;
        }
        return this.getId().toString().equals(volatileData.getString(key));
    }

    public boolean isOwner(IToolStackView tool) {
        return this.isOwner(tool.getVolatileData());
    }

    public int getCapacity(IModDataView volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IToolStackView tool) {
        return tool.getVolatileData().getInt(this.getCapacityKey());
    }

    public void addCapacity(ModDataNBT volatileNBT, int amount) {
        ResourceLocation key = this.getCapacityKey();
        if (volatileNBT.contains(key, 99)) {
            amount += volatileNBT.getInt(key);
        }
        volatileNBT.putInt(key, amount);
    }

    public FluidStack getFluid(IToolStackView tool) {
        return tool.getPersistentData().get(this.getFluidKey(), PARSE_FLUID);
    }

    public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
        if (fluid.isEmpty()) {
            tool.getPersistentData().remove(this.getFluidKey());
            return fluid;
        }
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
        }
        tool.getPersistentData().put(this.getFluidKey(), (Tag)fluid.writeToNBT(new CompoundTag()));
        return fluid;
    }

    public FluidStack fill(IToolStackView tool, FluidStack current, FluidStack resource, int amount) {
        int capacity = this.getCapacity(tool);
        if (current.isEmpty()) {
            resource.setAmount(Math.min(amount, capacity));
            return this.setFluid(tool, resource);
        }
        if (current.isFluidEqual(resource)) {
            current.setAmount(Math.min(current.getAmount() + amount, capacity));
            return this.setFluid(tool, current);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(IToolStackView tool, FluidStack current, int amount) {
        if (current.getAmount() < amount) {
            return this.setFluid(tool, FluidStack.EMPTY);
        }
        current.shrink(amount);
        return this.setFluid(tool, current);
    }

    public TankModifier(int capacity) {
        this.capacity = capacity;
    }

    public class ModifierTank
    implements ToolFluidCapability.IFluidModifier,
    ToolFluidCapability.FluidModifierHook {
        @Override
        public int getTanks(IModDataView volatileData) {
            return TankModifier.this.isOwner(volatileData) ? 1 : 0;
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? TankModifier.this.getFluid(tool) : FluidStack.EMPTY;
        }

        @Override
        public int getTankCapacity(IToolStackView tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? TankModifier.this.getCapacity(tool) : 0;
        }

        @Override
        public int fill(IToolStackView tool, int level, FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                int remaining = TankModifier.this.getCapacity(tool) - current.getAmount();
                if (remaining <= 0) {
                    return 0;
                }
                if (!current.isEmpty() && !current.isFluidEqual(resource)) {
                    return 0;
                }
                int filled = Math.min(remaining, resource.getAmount());
                if (filled > 0 && action.execute()) {
                    TankModifier.this.fill(tool, current, resource, filled);
                }
                return filled;
            }
            return 0;
        }

        @Override
        public FluidStack drain(IToolStackView tool, int level, FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                if (current.isEmpty() || !current.isFluidEqual(resource)) {
                    return FluidStack.EMPTY;
                }
                int drainedAmount = Math.min(current.getAmount(), resource.getAmount());
                FluidStack drained = new FluidStack(current, drainedAmount);
                if (action.execute()) {
                    TankModifier.this.drain(tool, current, drainedAmount);
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack drain(IToolStackView tool, int level, int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain > 0 && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                if (current.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                int drainedAmount = Math.min(current.getAmount(), maxDrain);
                FluidStack drained = new FluidStack(current, drainedAmount);
                if (action.execute()) {
                    TankModifier.this.drain(tool, current, drainedAmount);
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            return this.getTanks(tool.getVolatileData());
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            return this.getFluidInTank(tool, modifier.getLevel(), tank);
        }

        @Override
        public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            return this.getTankCapacity(tool, modifier.getLevel(), tank);
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            return this.isFluidValid(tool, modifier.getLevel(), tank, fluid);
        }

        @Override
        public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            return this.fill(tool, modifier.getLevel(), resource, action);
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drain(tool, modifier.getLevel(), resource, action);
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
            return this.drain(tool, modifier.getLevel(), maxDrain, action);
        }
    }
}

