/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

@Deprecated
public class MobEffectModifier
extends IncrementalModifier
implements ProjectileHitModifierHook,
ProjectileLaunchModifierHook {
    private final MobEffect effect;
    private final float levelBase;
    private final float levelMultiplier;
    private final int timeBase;
    private final int timeMultiplierFlat;
    private final int timeMultiplierRandom;
    public static final GenericLoaderRegistry.IGenericLoader<MobEffectModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<MobEffectModifier>(){

        public MobEffectModifier deserialize(JsonObject json) {
            MobEffect effect = (MobEffect)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (JsonObject)json, (String)"effect");
            float levelBase = 1.0f;
            float levelMultiplier = 0.0f;
            if (json.has("level")) {
                JsonObject level = GsonHelper.m_13930_((JsonObject)json, (String)"level");
                levelBase = GsonHelper.m_13820_((JsonObject)level, (String)"base", (float)0.0f);
                levelMultiplier = GsonHelper.m_13820_((JsonObject)level, (String)"multiplier", (float)0.0f);
            }
            JsonObject time = GsonHelper.m_13930_((JsonObject)json, (String)"time");
            int timeBase = GsonHelper.m_13824_((JsonObject)time, (String)"base", (int)0);
            int timeMultiplierFlat = GsonHelper.m_13824_((JsonObject)time, (String)"multiplier_flat", (int)0);
            int timeMultiplierRandom = GsonHelper.m_13824_((JsonObject)time, (String)"multiplier_random", (int)0);
            return new MobEffectModifier(effect, levelBase, levelMultiplier, timeBase, timeMultiplierFlat, timeMultiplierRandom);
        }

        public void serialize(MobEffectModifier object, JsonObject json) {
            json.addProperty("effect", Objects.requireNonNull(object.effect.getRegistryName()).toString());
            JsonObject level = new JsonObject();
            level.addProperty("base", (Number)Float.valueOf(object.levelBase));
            level.addProperty("multiplier", (Number)Float.valueOf(object.levelMultiplier));
            json.add("level", (JsonElement)level);
            JsonObject time = new JsonObject();
            time.addProperty("base", (Number)object.timeBase);
            time.addProperty("multiplier_flat", (Number)object.timeMultiplierFlat);
            time.addProperty("multiplier_random", (Number)object.timeMultiplierRandom);
            json.add("time", (JsonElement)time);
        }

        public MobEffectModifier fromNetwork(FriendlyByteBuf buffer) {
            MobEffect effect = (MobEffect)buffer.readRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS);
            float levelBase = buffer.readFloat();
            float levelMultiplier = buffer.readFloat();
            int timeBase = buffer.readInt();
            int timeMultiplierFlat = buffer.readInt();
            int timeMultiplierRandom = buffer.readInt();
            return new MobEffectModifier(effect, levelBase, levelMultiplier, timeBase, timeMultiplierFlat, timeMultiplierRandom);
        }

        public void toNetwork(MobEffectModifier object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS, (IForgeRegistryEntry)object.effect);
            buffer.writeFloat(object.levelBase);
            buffer.writeFloat(object.levelMultiplier);
            buffer.writeInt(object.timeBase);
            buffer.writeInt(object.timeMultiplierFlat);
            buffer.writeInt(object.timeMultiplierRandom);
        }
    };

    private void applyEffect(@Nullable LivingEntity target, float scaledLevel) {
        if (target == null) {
            return;
        }
        int level = Math.round(this.levelBase + scaledLevel * this.levelMultiplier) - 1;
        if (level < 0) {
            return;
        }
        float duration = (float)this.timeBase + scaledLevel * (float)this.timeMultiplierFlat;
        int randomBonus = (int)((float)this.timeMultiplierRandom * scaledLevel);
        if (randomBonus > 0) {
            duration += (float)RANDOM.nextInt(randomBonus);
        }
        if (duration > 0.0f) {
            target.m_7292_(new MobEffectInstance(this.effect, (int)duration, level));
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        if (isDirectDamage && attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            float scaledLevel = this.getEffectiveLevel(tool, level);
            if (RANDOM.nextFloat() < scaledLevel * 0.25f) {
                this.applyEffect(living, scaledLevel);
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        this.applyEffect(context.getLivingTarget(), this.getEffectiveLevel(tool, level));
        return 0;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        persistentData.putFloat(this.getId(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        this.applyEffect(target, persistentData.getFloat(this.getId()));
        return false;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.PROJECTILE_LAUNCH, TinkerHooks.PROJECTILE_HIT);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    private MobEffectModifier(MobEffect effect, float levelBase, float levelMultiplier, int timeBase, int timeMultiplierFlat, int timeMultiplierRandom) {
        this.effect = effect;
        this.levelBase = levelBase;
        this.levelMultiplier = levelMultiplier;
        this.timeBase = timeBase;
        this.timeMultiplierFlat = timeMultiplierFlat;
        this.timeMultiplierRandom = timeMultiplierRandom;
    }

    public static class Builder {
        private final MobEffect effect;
        private float levelBase = 1.0f;
        private float levelMultiplier = 0.0f;
        private int timeBase;
        private int timeMultiplierFlat;
        private int timeMultiplierRandom;

        public Builder level(float base, float multiplier) {
            this.levelBase = base;
            this.levelMultiplier = multiplier;
            return this;
        }

        public MobEffectModifier build() {
            return new MobEffectModifier(this.effect, this.levelBase, this.levelMultiplier, this.timeBase, this.timeMultiplierFlat, this.timeMultiplierRandom);
        }

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public static Builder effect(MobEffect effect) {
            return new Builder(effect);
        }

        public Builder timeBase(int timeBase) {
            this.timeBase = timeBase;
            return this;
        }

        public Builder timeMultiplierFlat(int timeMultiplierFlat) {
            this.timeMultiplierFlat = timeMultiplierFlat;
            return this;
        }

        public Builder timeMultiplierRandom(int timeMultiplierRandom) {
            this.timeMultiplierRandom = timeMultiplierRandom;
            return this;
        }
    }
}

