/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ElytraFlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EffectiveLevelModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageTakenModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.FinishHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorInteractModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorLootModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IElytraFlightModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class TinkerHooks {
    public static final ModifierHook<ConditionalStatModifierHook> CONDITIONAL_STAT = TinkerHooks.register("conditional_stat", ConditionalStatModifierHook.class, ConditionalStatModifierHook.ALL_MERGER, ConditionalStatModifierHook.EMPTY);
    public static final ModifierHook<ToolActionModifierHook> TOOL_ACTION = TinkerHooks.register("tool_action", ToolActionModifierHook.class, ToolActionModifierHook.AnyMerger::new, (tool, modifier, toolAction) -> modifier.getModifier().canPerformAction(tool, modifier.getLevel(), toolAction));
    public static final ModifierHook<EquipmentChangeModifierHook> EQUIPMENT_CHANGE = TinkerHooks.register("equipment_change", EquipmentChangeModifierHook.class, EquipmentChangeModifierHook.AllMerger::new, new EquipmentChangeModifierHook(){

        @Override
        public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
            modifier.getModifier().onEquip(tool, modifier.getLevel(), context);
        }

        @Override
        public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
            modifier.getModifier().onUnequip(tool, modifier.getLevel(), context);
        }

        @Override
        public void onEquipmentChange(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, EquipmentSlot slotType) {
            modifier.getModifier().onEquipmentChange(tool, modifier.getLevel(), context, slotType);
        }
    });
    public static final ModifierHook<RepairFactorModifierHook> REPAIR_FACTOR = TinkerHooks.register("repair_factor", RepairFactorModifierHook.class, RepairFactorModifierHook.ComposeMerger::new, (tool, entry, factor) -> entry.getModifier().getRepairFactor(tool, entry.getLevel(), factor));
    public static final ModifierHook<ToolDamageModifierHook> TOOL_DAMAGE = TinkerHooks.register("tool_damage", ToolDamageModifierHook.class, ToolDamageModifierHook.Merger::new, (tool, modifier, amount, holder) -> modifier.getModifier().onDamageTool(tool, modifier.getLevel(), amount, holder));
    public static final ModifierHook<InventoryTickModifierHook> INVENTORY_TICK = TinkerHooks.register("inventory_tick", InventoryTickModifierHook.class, InventoryTickModifierHook.AllMerger::new, (tool, modifier, world, holder, itemSlot, isSelected, isCorrectSlot, stack) -> modifier.getModifier().onInventoryTick(tool, modifier.getLevel(), world, holder, itemSlot, isSelected, isCorrectSlot, stack));
    public static final ModifierHook<EffectiveLevelModifierHook> EFFECTIVE_LEVEL = TinkerHooks.register("effective_level", EffectiveLevelModifierHook.class, EffectiveLevelModifierHook.ComposeMerger::new, (tool, modifier, level) -> level);
    public static final ModifierHook<DisplayNameModifierHook> DISPLAY_NAME = TinkerHooks.register("display_name", DisplayNameModifierHook.class, DisplayNameModifierHook.ComposeMerger::new, (tool, modifier, level, name) -> name);
    public static final ModifierHook<TooltipModifierHook> TOOLTIP = TinkerHooks.register("tooltip", TooltipModifierHook.class, TooltipModifierHook.AllMerger::new, (tool, modifier, player, tooltip, tooltipKey, tooltipFlag) -> modifier.getModifier().addInformation(tool, modifier.getLevel(), player, (List<Component>)tooltip, tooltipKey, tooltipFlag));
    public static final ModifierHook<DurabilityDisplayModifierHook> DURABILITY_DISPLAY = TinkerHooks.register("durability_display", DurabilityDisplayModifierHook.class, DurabilityDisplayModifierHook.FirstMerger::new, new DurabilityDisplayModifierHook(){

        @Override
        @Nullable
        public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
            return modifier.getModifier().showDurabilityBar(tool, modifier.getLevel());
        }

        @Override
        public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
            double damagePercent = modifier.getModifier().getDamagePercentage(tool, modifier.getLevel());
            if (Double.isNaN(damagePercent)) {
                return 0;
            }
            return (int)(1.0 + 12.75 * (1.0 - damagePercent));
        }

        @Override
        public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
            return modifier.getModifier().getDurabilityRGB(tool, modifier.getLevel());
        }
    });
    public static final ModifierHook<ToolStatsModifierHook> TOOL_STATS = TinkerHooks.register("tool_stats", ToolStatsModifierHook.class, ToolStatsModifierHook.AllMerger::new, (context, modifier, builder) -> modifier.getModifier().addToolStats(context, modifier.getLevel(), builder));
    public static final ModifierHook<AttributesModifierHook> ATTRIBUTES = TinkerHooks.register("attributes", AttributesModifierHook.class, AttributesModifierHook.AllMerger::new, (tool, modifier, slot, consumer) -> modifier.getModifier().addAttributes(tool, modifier.getLevel(), slot, consumer));
    public static final ModifierHook<VolatileDataModifierHook> VOLATILE_DATA = TinkerHooks.register("volatile_data", VolatileDataModifierHook.class, VolatileDataModifierHook.AllMerger::new, (context, modifier, volatileData) -> modifier.getModifier().addVolatileData(context, modifier.getLevel(), volatileData));
    public static final ModifierHook<RawDataModifierHook> RAW_DATA = TinkerHooks.register("raw_data", RawDataModifierHook.class, RawDataModifierHook.AllMerger::new, new RawDataModifierHook(){

        @Override
        public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
            modifier.getModifier().addRawData(tool, modifier.getLevel(), tag);
        }

        @Override
        public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
            modifier.beforeRemoved(tool, tag);
        }
    });
    public static final ModifierHook<ValidateModifierHook> VALIDATE = TinkerHooks.register("validate", ValidateModifierHook.class, ValidateModifierHook.AllMerger::new, (tool, modifier) -> {
        ValidatedResult result = modifier.getModifier().validate(tool, modifier.getLevel());
        if (result.hasError()) {
            return result.getMessage();
        }
        return null;
    });
    public static final ModifierHook<ModifierRemovalHook> REMOVE = TinkerHooks.register("remove", ModifierRemovalHook.class, ModifierRemovalHook.FirstMerger::new, (tool, modifier) -> {
        modifier.onRemoved(tool);
        ValidatedResult result = modifier.validate(tool, 0);
        if (result.hasError()) {
            return result.getMessage();
        }
        return null;
    });
    public static final ModifierHook<ModifierTraitHook> MODIFIER_TRAITS = TinkerHooks.register("modifier_traits", ModifierTraitHook.class, ModifierTraitHook.AllMerger::new, (context, modifier, builder, firstEncounter) -> {});
    public static final ModifierHook<MeleeDamageModifierHook> MELEE_DAMAGE = TinkerHooks.register("melee_damage", MeleeDamageModifierHook.class, MeleeDamageModifierHook.AllMerger::new, (tool, modifier, context, baseDamage, damage) -> modifier.getModifier().getEntityDamage(tool, modifier.getLevel(), context, baseDamage, damage));
    public static final ModifierHook<MeleeHitModifierHook> MELEE_HIT = TinkerHooks.register("melee_hit", MeleeHitModifierHook.class, MeleeHitModifierHook.AllMerger::new, new MeleeHitModifierHook(){

        @Override
        public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
            return modifier.getModifier().beforeEntityHit(tool, modifier.getLevel(), context, damage, baseKnockback, knockback);
        }

        @Override
        public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
            int damage = modifier.getModifier().afterEntityHit(tool, modifier.getLevel(), context, damageDealt);
            if (damage > 0) {
                ToolDamageUtil.damageAnimated(tool, damage, context.getAttacker(), context.getSlotType());
            }
        }

        @Override
        public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
            modifier.getModifier().failedEntityHit(tool, modifier.getLevel(), context);
        }
    });
    public static final ModifierHook<ProtectionModifierHook> PROTECTION = TinkerHooks.register("protection", ProtectionModifierHook.class, ProtectionModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, modifierValue) -> modifier.getModifier().getProtectionModifier(tool, modifier.getLevel(), context, slotType, source, modifierValue));
    public static final ModifierHook<DamageBlockModifierHook> DAMAGE_BLOCK = TinkerHooks.register("damage_block", DamageBlockModifierHook.class, DamageBlockModifierHook.AnyMerger::new, (tool, modifier, context, slotType, source, amount) -> modifier.getModifier().isSourceBlocked(tool, modifier.getLevel(), context, slotType, source, amount));
    public static final ModifierHook<DamageTakenModifierHook> DAMAGE_TAKEN = TinkerHooks.register("damage_taken", DamageTakenModifierHook.class, DamageTakenModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, amount, isDirectDamage) -> modifier.getModifier().onAttacked(tool, modifier.getLevel(), context, slotType, source, amount, isDirectDamage));
    public static final ModifierHook<ModifyDamageModifierHook> MODIFY_HURT;
    public static final ModifierHook<ModifyDamageModifierHook> MODIFY_DAMAGE;
    public static final ModifierHook<DamageDealtModifierHook> DAMAGE_DEALT;
    public static final ModifierHook<LootingModifierHook> TOOL_LOOTING;
    public static final ModifierHook<LootingModifierHook> LEGGINGS_LOOTING;
    public static final ModifierHook<LootingModifierHook> PROJECTILE_LOOTING;
    public static final ModifierHook<HarvestEnchantmentsModifierHook> TOOL_HARVEST_ENCHANTMENTS;
    public static final ModifierHook<HarvestEnchantmentsModifierHook> LEGGINGS_HARVEST_ENCHANTMENTS;
    public static final ModifierHook<BreakSpeedModifierHook> BREAK_SPEED;
    public static final ModifierHook<RemoveBlockModifierHook> REMOVE_BLOCK;
    public static final ModifierHook<BlockBreakModifierHook> BLOCK_BREAK;
    public static final ModifierHook<FinishHarvestModifierHook> FINISH_HARVEST;
    public static final ModifierHook<ProjectileLaunchModifierHook> PROJECTILE_LAUNCH;
    public static final ModifierHook<ProjectileHitModifierHook> PROJECTILE_HIT;
    public static final ModifierHook<BowAmmoModifierHook> BOW_AMMO;
    public static final ModifierHook<ElytraFlightModifierHook> ELYTRA_FLIGHT;
    public static final ModifierHook<ArmorWalkModifierHook> BOOT_WALK;
    @Deprecated
    public static final ModifierHook<GeneralInteractionModifierHook> GENERAL_INTERACT;
    public static final ModifierHook<GeneralInteractionModifierHook> CHARGEABLE_INTERACT;
    public static final ModifierHook<BlockInteractionModifierHook> BLOCK_INTERACT;
    public static final ModifierHook<EntityInteractionModifierHook> ENTITY_INTERACT;
    public static final ModifierHook<KeybindInteractModifierHook> ARMOR_INTERACT;
    public static final ModifierHook<PlantHarvestModifierHook> PLANT_HARVEST;
    public static final ModifierHook<ShearsModifierHook> SHEAR_ENTITY;
    public static final ModifierHook<BlockTransformModifierHook> BLOCK_TRANSFORM;

    private TinkerHooks() {
    }

    public static void init() {
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return ModifierHooks.register(TConstruct.getResource(name), filter, defaultInstance, merger);
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, T defaultInstance) {
        return TinkerHooks.register(name, filter, null, defaultInstance);
    }

    static {
        Function<Collection, ModifyDamageModifierHook> merger = ModifyDamageModifierHook.AllMerger::new;
        ModifyDamageModifierHook fallback = (tool, modifier, context, slotType, source, amount, isDirectDamage) -> amount;
        MODIFY_HURT = TinkerHooks.register("modify_hurt", ModifyDamageModifierHook.class, merger, fallback);
        MODIFY_DAMAGE = TinkerHooks.register("modify_damage", ModifyDamageModifierHook.class, merger, fallback);
        DAMAGE_DEALT = TinkerHooks.register("damage_dealt", DamageDealtModifierHook.class, DamageDealtModifierHook.AllMerger::new, (tool, modifier, context, slotType, target, source, amount, isDirectDamage) -> modifier.getModifier().attackWithArmor(tool, modifier.getLevel(), context, slotType, target, source, amount, isDirectDamage));
        TOOL_LOOTING = TinkerHooks.register("tool_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, (tool, modifier, holder, target, damageSource, looting) -> modifier.getModifier().getLootingValue(tool, modifier.getLevel(), holder, target, damageSource, looting));
        LEGGINGS_LOOTING = TinkerHooks.register("leggings_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, (tool, modifier, holder, target, damageSource, looting) -> {
            IArmorLootModifier armorLoot = modifier.getModifier().getModule(IArmorLootModifier.class);
            if (armorLoot != null) {
                return armorLoot.getLootingValue(tool, modifier.getLevel(), holder, target, damageSource, looting);
            }
            return looting;
        });
        PROJECTILE_LOOTING = TinkerHooks.register("projectile_looting", LootingModifierHook.class, LootingModifierHook.SUM_MERGER, LootingModifierHook.DEFAULT);
        TOOL_HARVEST_ENCHANTMENTS = TinkerHooks.register("tool_harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.ALL_MERGER, (tool, modifier, context, consumer) -> modifier.getModifier().applyHarvestEnchantments(tool, modifier.getLevel(), context, consumer));
        LEGGINGS_HARVEST_ENCHANTMENTS = TinkerHooks.register("leggings_harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.ALL_MERGER, (tool, modifier, context, consumer) -> {
            IArmorLootModifier armorLoot = modifier.getModifier().getModule(IArmorLootModifier.class);
            if (armorLoot != null) {
                armorLoot.applyHarvestEnchantments(tool, modifier.getLevel(), context, consumer);
            }
        });
        BREAK_SPEED = TinkerHooks.register("break_speed", BreakSpeedModifierHook.class, BreakSpeedModifierHook.AllMerger::new, (tool, modifier, event, sideHit, isEffective, miningSpeedModifier) -> modifier.getModifier().onBreakSpeed(tool, modifier.getLevel(), event, sideHit, isEffective, miningSpeedModifier));
        REMOVE_BLOCK = TinkerHooks.register("remove_block", RemoveBlockModifierHook.class, RemoveBlockModifierHook.FirstMerger::new, (tool, modifier, context) -> modifier.getModifier().removeBlock(tool, modifier.getLevel(), context));
        BLOCK_BREAK = TinkerHooks.register("block_break", BlockBreakModifierHook.class, BlockBreakModifierHook.AllMerger::new, (tool, modifier, context) -> modifier.getModifier().afterBlockBreak(tool, modifier.getLevel(), context));
        FINISH_HARVEST = TinkerHooks.register("finish_harvest", FinishHarvestModifierHook.class, FinishHarvestModifierHook.AllMerger::new, (tool, modifier, context) -> modifier.getModifier().finishBreakingBlocks(tool, modifier.getLevel(), context));
        PROJECTILE_LAUNCH = TinkerHooks.register("projectile_launch", ProjectileLaunchModifierHook.class, ProjectileLaunchModifierHook.ALL_MERGER, ProjectileLaunchModifierHook.EMPTY);
        PROJECTILE_HIT = TinkerHooks.register("projectile_hit", ProjectileHitModifierHook.class, ProjectileHitModifierHook.FIRST_MERGER, ProjectileHitModifierHook.EMPTY);
        BOW_AMMO = TinkerHooks.register("bow_ammo", BowAmmoModifierHook.class, BowAmmoModifierHook.EMPTY);
        ELYTRA_FLIGHT = TinkerHooks.register("elytra_flight", ElytraFlightModifierHook.class, ElytraFlightModifierHook.FIRST_MERGER, (tool, modifier, entity, flightTicks) -> {
            IElytraFlightModifier elytraFlight = modifier.getModifier().getModule(IElytraFlightModifier.class);
            return elytraFlight != null && !elytraFlight.elytraFlightTick(tool, modifier.getLevel(), entity, flightTicks);
        });
        BOOT_WALK = TinkerHooks.register("boot_walk", ArmorWalkModifierHook.class, ArmorWalkModifierHook.ALL_MERGER, (tool, modifier, living, prevPos, newPos) -> {
            IArmorWalkModifier armorWalk = modifier.getModifier().getModule(IArmorWalkModifier.class);
            if (armorWalk != null) {
                armorWalk.onWalk(tool, modifier.getLevel(), living, prevPos, newPos);
            }
        });
        GENERAL_INTERACT = TinkerHooks.register("general_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FIRST_MERGER, GeneralInteractionModifierHook.FALLBACK);
        CHARGEABLE_INTERACT = TinkerHooks.register("chargable_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FIRST_MERGER, (tool, modifier, player, hand, source) -> modifier.getHook(GENERAL_INTERACT).onToolUse(tool, modifier, player, hand, source));
        BLOCK_INTERACT = TinkerHooks.register("block_interact", BlockInteractionModifierHook.class, BlockInteractionModifierHook.FIRST_MERGER, BlockInteractionModifierHook.FALLBACK);
        ENTITY_INTERACT = TinkerHooks.register("entity_interact", EntityInteractionModifierHook.class, EntityInteractionModifierHook.FIRST_MERGER, EntityInteractionModifierHook.FALLBACK);
        ARMOR_INTERACT = TinkerHooks.register("armor_interact", KeybindInteractModifierHook.class, KeybindInteractModifierHook.MERGER, new KeybindInteractModifierHook(){

            @Override
            public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
                IArmorInteractModifier interact = modifier.getModifier().getModule(IArmorInteractModifier.class);
                if (interact != null) {
                    return interact.startArmorInteract(tool, modifier.getLevel(), player, slot, keyModifier);
                }
                return false;
            }

            @Override
            public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
                IArmorInteractModifier interact = modifier.getModifier().getModule(IArmorInteractModifier.class);
                if (interact != null) {
                    interact.stopArmorInteract(tool, modifier.getLevel(), player, slot);
                }
            }
        });
        PLANT_HARVEST = TinkerHooks.register("plant_harvest", PlantHarvestModifierHook.class, PlantHarvestModifierHook.ALL_MERGER, (tool, modifier, context, world, state, pos) -> {
            IHarvestModifier plantHarvest = modifier.getModifier().getModule(IHarvestModifier.class);
            if (plantHarvest != null) {
                plantHarvest.afterHarvest(tool, modifier.getLevel(), context, world, state, pos);
            }
        });
        SHEAR_ENTITY = TinkerHooks.register("shear_entity", ShearsModifierHook.class, ShearsModifierHook.ALL_MERGER, new ShearsModifierHook(){

            @Override
            public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
                IShearModifier shearModifier = modifier.getModifier().getModule(IShearModifier.class);
                if (shearModifier != null) {
                    shearModifier.afterShearEntity(tool, modifier.getLevel(), player, entity, isTarget);
                }
            }
        });
        BLOCK_TRANSFORM = TinkerHooks.register("block_transform", BlockTransformModifierHook.class, BlockTransformModifierHook.ALL_MERGER, BlockTransformModifierHook.EMPTY);
    }
}

