/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.stat;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ConditionalStatFormula(ModifierFormula formula, List<ConditionalStatVariable> variables, String[] variableNames) implements VariableFormula<ConditionalStatVariable>
{
    private static final BiFunction<ModifierFormula, List<ConditionalStatVariable>, ConditionalStatFormula> CONSTRUCTOR = (formula, variables) -> new ConditionalStatFormula((ModifierFormula)formula, (List<ConditionalStatVariable>)variables, EMPTY_STRINGS);
    public static final String[] VARIABLES = new String[]{"level", "value", "multiplier"};

    public ConditionalStatFormula(ModifierFormula formula, Map<String, ConditionalStatVariable> variables) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables));
    }

    @Override
    public GenericLoaderRegistry<ConditionalStatVariable> loader() {
        return ConditionalStatVariable.LOADER;
    }

    @Override
    public String[] defaultVariableNames() {
        return VARIABLES;
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity entity, float value, float multiplier) {
        int size = this.variables.size();
        float[] arguments = new float[3 + size];
        arguments[0] = this.formula.computeLevel(tool, modifier);
        arguments[1] = value;
        arguments[2] = multiplier;
        for (int i = 0; i < size; ++i) {
            arguments[3 + i] = this.variables.get(i).getValue(tool, entity);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity entity, float value, float multiplier) {
        return this.formula.apply(this.getArguments(tool, modifier, entity, value, multiplier));
    }

    public static ConditionalStatFormula deserialize(JsonObject json, boolean percent) {
        return VariableFormula.deserialize(ConditionalStatVariable.LOADER, CONSTRUCTOR, json, VARIABLES, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }

    public static ConditionalStatFormula fromNetwork(FriendlyByteBuf buffer, boolean percent) {
        return VariableFormula.fromNetwork(ConditionalStatVariable.LOADER, CONSTRUCTOR, buffer, VARIABLES.length, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }
}

