/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.math.PostFixFormula;
import slimeknights.tconstruct.library.json.math.StackOperation;

public interface VariableFormula<T extends GenericLoaderRegistry.IHaveLoader<T>> {
    public static final String[] EMPTY_STRINGS = new String[0];

    public GenericLoaderRegistry<T> loader();

    public ModifierFormula formula();

    public List<T> variables();

    public String[] variableNames();

    public String[] defaultVariableNames();

    public static float[] statModuleArguments(int variables, float level, float baseValue, float value, float multiplier) {
        float[] arguments = new float[4 + variables];
        arguments[0] = level;
        arguments[1] = value;
        arguments[2] = multiplier;
        arguments[3] = baseValue;
        return arguments;
    }

    default public JsonObject serialize(JsonObject json) {
        List<T> variables = this.variables();
        if (!variables.isEmpty()) {
            JsonObject variablesObject = new JsonObject();
            GenericLoaderRegistry<T> loader = this.loader();
            String[] variableNames = this.variableNames();
            for (int i = 0; i < variableNames.length; ++i) {
                variablesObject.add(variableNames[i], loader.serialize((GenericLoaderRegistry.IHaveLoader)variables.get(i)));
            }
            json.add("variables", (JsonElement)variablesObject);
        }
        this.formula().serialize(json, this.defaultVariableNames());
        return json;
    }

    public static <C extends VariableFormula<T>, T extends GenericLoaderRegistry.IHaveLoader<T>> C deserialize(GenericLoaderRegistry<T> loader, BiFunction<ModifierFormula, List<T>, C> constructor, JsonObject json, String[] defaultNames, ModifierFormula.FallbackFormula fallback) {
        if (json.has("variables")) {
            if (!json.has("formula")) {
                throw new JsonSyntaxException("Cannot set variables when not using formula");
            }
            ImmutableList.Builder variables = ImmutableList.builder();
            int index = defaultNames.length;
            JsonObject variableObj = GsonHelper.m_13930_((JsonObject)json, (String)"variables");
            String[] newNames = Arrays.copyOf(defaultNames, index + variableObj.size());
            for (Map.Entry entry : variableObj.entrySet()) {
                String key = (String)entry.getKey();
                if (LogicHelper.isInList((Object[])defaultNames, (Object)key)) {
                    throw new JsonSyntaxException("Variable " + key + " is already defined for this module");
                }
                newNames[index] = key;
                variables.add((Object)loader.deserialize((JsonElement)entry.getValue()));
                ++index;
            }
            return (C)((VariableFormula)constructor.apply(PostFixFormula.deserialize(json, newNames), (List<ModifierFormula>)variables.build()));
        }
        return (C)((VariableFormula)constructor.apply(ModifierFormula.deserialize(json, defaultNames, fallback), List.of()));
    }

    default public void toNetwork(FriendlyByteBuf buffer) {
        List<T> variables = this.variables();
        GenericLoaderRegistry<T> loader = this.loader();
        buffer.m_130130_(variables.size());
        for (GenericLoaderRegistry.IHaveLoader variable : variables) {
            loader.toNetwork(variable, buffer);
        }
        this.formula().toNetwork(buffer);
    }

    public static <C extends VariableFormula<T>, T extends GenericLoaderRegistry.IHaveLoader<T>> C fromNetwork(GenericLoaderRegistry<T> loader, BiFunction<ModifierFormula, List<T>, C> constructor, FriendlyByteBuf buffer, int defaultVariables, ModifierFormula.FallbackFormula fallback) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)loader.fromNetwork(buffer));
        }
        ImmutableList variables = builder.build();
        return (C)((VariableFormula)constructor.apply(ModifierFormula.fromNetwork(buffer, defaultVariables + variables.size(), fallback), (List<ModifierFormula>)variables));
    }

    public static String[] getNames(Map<String, ?> variables) {
        return variables.keySet().toArray(new String[0]);
    }

    public static abstract class Builder<T extends Builder<T, M, V>, M, V>
    extends ModifierFormula.Builder<T, M> {
        protected final Map<String, V> variables = new LinkedHashMap<String, V>();

        public Builder(String[] variables) {
            super(variables);
        }

        public T customVariable(String key, V variable) {
            if (LogicHelper.isInList((Object[])this.variableNames, (Object)key)) {
                throw new IllegalArgumentException("Variable " + key + " already exists in the module's variables");
            }
            V original = this.variables.put(key, variable);
            if (original != null) {
                throw new IllegalStateException("Duplicate variable name " + key + ", previous entry " + original);
            }
            return (T)this;
        }

        public FormulaVariableBuilder formula() {
            return new FormulaVariableBuilder();
        }

        public class FormulaVariableBuilder
        extends ModifierFormula.Builder.FormulaBuilder<FormulaVariableBuilder, M> {
            protected FormulaVariableBuilder() {
                super(Builder.this);
            }

            public FormulaVariableBuilder customVariable(String name) {
                if (!Builder.this.variables.containsKey(name)) {
                    throw new IllegalArgumentException("Unknown custom variable " + name);
                }
                return (FormulaVariableBuilder)this.operation(new SerializeVariableName(name));
            }

            public FormulaVariableBuilder customVariable(String name, V variable) {
                Builder.this.customVariable(name, variable);
                return (FormulaVariableBuilder)this.operation(new SerializeVariableName(name));
            }

            private record SerializeVariableName(String name) implements StackOperation
            {
                @Override
                public void perform(FloatStack stack, float[] variables) {
                    stack.push(0.0f);
                }

                @Override
                public JsonPrimitive serialize(String[] variableNames) {
                    return new JsonPrimitive("$" + this.name);
                }

                @Override
                public void toNetwork(FriendlyByteBuf buffer) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

