/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public record HasStatTypePredicate(MaterialStatsId statType, @Nullable MaterialVariantId material) implements ToolContextPredicate
{
    public static final GenericLoaderRegistry.IGenericLoader<HasStatTypePredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<HasStatTypePredicate>(){

        public HasStatTypePredicate deserialize(JsonObject json) {
            MaterialStatsId statType = MaterialStatsId.PARSER.getFromJson(json, "stat_type");
            MaterialVariantId material = null;
            if (json.has("material")) {
                material = MaterialVariantId.fromJson(json, "material");
            }
            return new HasStatTypePredicate(statType, material);
        }

        public void serialize(HasStatTypePredicate object, JsonObject json) {
            json.addProperty("stat_type", object.statType.toString());
            if (object.material != null) {
                json.addProperty("material", object.material.toString());
            }
        }

        public HasStatTypePredicate fromNetwork(FriendlyByteBuf buffer) {
            MaterialStatsId statType = MaterialStatsId.PARSER.fromNetwork(buffer);
            MaterialVariantId material = null;
            if (buffer.readBoolean()) {
                material = MaterialVariantId.fromNetwork(buffer);
            }
            return new HasStatTypePredicate(statType, material);
        }

        public void toNetwork(HasStatTypePredicate object, FriendlyByteBuf buffer) {
            buffer.m_130085_((ResourceLocation)object.statType);
            if (object.material != null) {
                buffer.writeBoolean(true);
                object.material.toNetwork(buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }
    };

    public HasStatTypePredicate(MaterialStatsId statType) {
        this(statType, null);
    }

    public boolean matches(IToolContext tool) {
        List<PartRequirement> parts = tool.getDefinition().getData().getParts();
        for (int i = 0; i < parts.size(); ++i) {
            if (!this.statType.equals((Object)parts.get(i).getStatType()) || this.material != null && !this.material.matchesVariant(tool.getMaterial(i))) continue;
            return true;
        }
        return false;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<IToolContext>> getLoader() {
        return LOADER;
    }
}

