/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public record HasModifierPredicate(ModifierId modifier, IntRange level, ModifierCheck check) implements ToolContextPredicate
{
    public static final IntRange MAX_RANGE = new IntRange(0, Short.MAX_VALUE);
    public static final IntRange DEFAULT_RANGE = MAX_RANGE.min(1);
    public static final GenericLoaderRegistry.IGenericLoader<HasModifierPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<HasModifierPredicate>(){

        public HasModifierPredicate deserialize(JsonObject json) {
            ModifierId modifier = ModifierId.getFromJson(json, "modifier");
            IntRange level = DEFAULT_RANGE;
            if (json.has("level")) {
                level = MAX_RANGE.getAndDeserialize(json, "level");
            }
            ModifierCheck check = (ModifierCheck)JsonHelper.getAsEnum((JsonObject)json, (String)"check", ModifierCheck.class);
            return new HasModifierPredicate(modifier, level, check);
        }

        public void serialize(HasModifierPredicate object, JsonObject json) {
            json.addProperty("modifier", object.modifier.toString());
            json.add("level", MAX_RANGE.serialize(object.level));
            json.addProperty("check", object.check.name().toLowerCase(Locale.ROOT));
        }

        public HasModifierPredicate fromNetwork(FriendlyByteBuf buffer) {
            ModifierId modifier = ModifierId.fromNetwork(buffer);
            IntRange level = IntRange.fromNetwork(buffer);
            ModifierCheck check = (ModifierCheck)buffer.m_130066_(ModifierCheck.class);
            return new HasModifierPredicate(modifier, level, check);
        }

        public void toNetwork(HasModifierPredicate object, FriendlyByteBuf buffer) {
            object.modifier.toNetwork(buffer);
            object.level.toNetwork(buffer);
            buffer.m_130068_((Enum)object.check);
        }
    };

    public HasModifierPredicate(ModifierId modifier, ModifierCheck check) {
        this(modifier, DEFAULT_RANGE, check);
    }

    public boolean matches(IToolContext tool) {
        return this.level.test(this.check.getModifiers(tool).getLevel(this.modifier));
    }

    @Override
    public IJsonPredicate<IToolContext> inverted() {
        if (this.level.max() == MAX_RANGE.max()) {
            return new HasModifierPredicate(this.modifier, new IntRange(MAX_RANGE.min(), this.level.min() - 1), this.check);
        }
        if (this.level.min() == MAX_RANGE.min()) {
            return new HasModifierPredicate(this.modifier, new IntRange(this.level.max() + 1, MAX_RANGE.max()), this.check);
        }
        return ToolContextPredicate.super.inverted();
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<IToolContext>> getLoader() {
        return LOADER;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ModifierCheck {
        UPGRADES{

            @Override
            public ModifierNBT getModifiers(IToolContext tool) {
                return tool.getUpgrades();
            }
        }
        ,
        ALL{

            @Override
            public ModifierNBT getModifiers(IToolContext tool) {
                return tool.getModifiers();
            }
        };


        public abstract ModifierNBT getModifiers(IToolContext var1);
    }
}

