/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public record HasMaterialPredicate(MaterialVariantId material, int index) implements ToolContextPredicate
{
    public static final GenericLoaderRegistry.IGenericLoader<HasMaterialPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<HasMaterialPredicate>(){

        public HasMaterialPredicate deserialize(JsonObject json) {
            MaterialVariantId material = MaterialVariantId.fromJson(json, "material");
            int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)-1);
            return new HasMaterialPredicate(material, index);
        }

        public void serialize(HasMaterialPredicate object, JsonObject json) {
            json.addProperty("material", object.material.toString());
            if (object.index != -1) {
                json.addProperty("index", (Number)object.index);
            }
        }

        public HasMaterialPredicate fromNetwork(FriendlyByteBuf buffer) {
            MaterialVariantId material = MaterialVariantId.fromNetwork(buffer);
            short index = buffer.readShort();
            return new HasMaterialPredicate(material, index);
        }

        public void toNetwork(HasMaterialPredicate object, FriendlyByteBuf buffer) {
            object.material.toNetwork(buffer);
            buffer.writeShort(object.index);
        }
    };

    public HasMaterialPredicate(MaterialVariantId material) {
        this(material, -1);
    }

    public boolean matches(IToolContext input) {
        if (this.index >= 0) {
            return this.material.matchesVariant(input.getMaterial(this.index));
        }
        for (MaterialVariant variant : input.getMaterials().getList()) {
            if (!this.material.matchesVariant(variant)) continue;
            return true;
        }
        return false;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<IToolContext>> getLoader() {
        return LOADER;
    }
}

