/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TagNotEmptyLootCondition<T>
implements LootItemCondition,
ICondition {
    private static final ResourceLocation NAME = TConstruct.getResource("tag_not_empty");
    private final TagKey<T> tag;

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)TinkerCommons.lootTagNotEmptyCondition.get();
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        Registry registry = RegistryHelper.getRegistry((ResourceKey)this.tag.f_203867_());
        return registry != null && registry.m_206058_(this.tag).iterator().hasNext();
    }

    public boolean test(ICondition.IContext context) {
        if (context.getAllTags(this.tag.f_203867_()).isEmpty()) {
            return this.test();
        }
        return !context.getTag(this.tag).m_6497_().isEmpty();
    }

    public boolean test(LootContext context) {
        return this.test();
    }

    public TagNotEmptyLootCondition(TagKey<T> tag) {
        this.tag = tag;
    }

    public static class ConditionSerializer
    implements Serializer<TagNotEmptyLootCondition<?>>,
    IConditionSerializer<TagNotEmptyLootCondition<?>> {
        private static <T> TagKey<T> createKey(JsonObject json) {
            ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"registry"));
            return TagKey.m_203882_((ResourceKey)registry, (ResourceLocation)JsonHelper.getResourceLocation((JsonObject)json, (String)"tag"));
        }

        public void write(JsonObject json, TagNotEmptyLootCondition<?> value) {
            json.addProperty("registry", value.tag.f_203867_().m_135782_().toString());
            json.addProperty("tag", value.tag.f_203868_().toString());
        }

        public void serialize(JsonObject json, TagNotEmptyLootCondition<?> value, JsonSerializationContext context) {
            this.write(json, value);
        }

        public TagNotEmptyLootCondition<?> read(JsonObject json) {
            return new TagNotEmptyLootCondition(ConditionSerializer.createKey(json));
        }

        public TagNotEmptyLootCondition<?> deserialize(JsonObject json, JsonDeserializationContext context) {
            return this.read(json);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

