/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.TConstruct;

public record RandomLevelingValue(float flat, float perLevel, float randomBonus) {
    public float computeValue(float level) {
        float value = this.flat + this.perLevel * level;
        if (this.randomBonus > 0.0f && level > 0.0f) {
            value += TConstruct.RANDOM.nextFloat() * level * this.randomBonus;
        }
        return value;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.flat != 0.0f) {
            json.addProperty("flat", (Number)Float.valueOf(this.flat));
        }
        if (this.perLevel != 0.0f) {
            json.addProperty("per_level", (Number)Float.valueOf(this.perLevel));
        }
        if (this.randomBonus != 0.0f) {
            json.addProperty("random", (Number)Float.valueOf(this.randomBonus));
        }
        return json;
    }

    public static RandomLevelingValue deserialize(JsonObject json) {
        float flat = GsonHelper.m_13820_((JsonObject)json, (String)"flat", (float)0.0f);
        float leveling = GsonHelper.m_13820_((JsonObject)json, (String)"per_level", (float)0.0f);
        float random = GsonHelper.m_13820_((JsonObject)json, (String)"random", (float)0.0f);
        return new RandomLevelingValue(flat, leveling, random);
    }

    public static RandomLevelingValue get(JsonObject parent, String key) {
        return RandomLevelingValue.deserialize(GsonHelper.m_13930_((JsonObject)parent, (String)key));
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.flat);
        buffer.writeFloat(this.perLevel);
        buffer.writeFloat(this.randomBonus);
    }

    public static RandomLevelingValue fromNetwork(FriendlyByteBuf buffer) {
        float flat = buffer.readFloat();
        float leveling = buffer.readFloat();
        float random = buffer.readFloat();
        return new RandomLevelingValue(flat, leveling, random);
    }

    public static RandomLevelingValue flat(float value) {
        return new RandomLevelingValue(value, 0.0f, 0.0f);
    }

    public static RandomLevelingValue perLevel(float flat, float leveling) {
        return new RandomLevelingValue(flat, leveling, 0.0f);
    }

    public static RandomLevelingValue random(float flat, float random) {
        return new RandomLevelingValue(flat, 0.0f, random);
    }
}

