/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ConstantFluidContainerWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final FluidStack fluid;
    private boolean empty = false;
    @Nonnull
    protected ItemStack container;
    private final ItemStack emptyStack;

    public ConstantFluidContainerWrapper(FluidStack fluid, ItemStack container, ItemStack emptyStack) {
        this.fluid = fluid;
        this.container = container;
        this.emptyStack = emptyStack;
    }

    public ConstantFluidContainerWrapper(FluidStack fluid, ItemStack container) {
        this(fluid, container, container.getContainerItem());
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return this.fluid.getAmount();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack.isEmpty() || stack.getFluid() == this.fluid.getFluid();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.empty ? FluidStack.EMPTY : this.fluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.empty || resource.getFluid() != this.fluid.getFluid() || resource.getAmount() < this.fluid.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.container = this.emptyStack;
            this.empty = true;
        }
        return this.fluid.copy();
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.empty || maxDrain < this.fluid.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.container = this.emptyStack;
            this.empty = true;
        }
        return this.fluid.copy();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }
}

