/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.ModelFluidAttributes;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.FluidTooltipProvider;
import slimeknights.tconstruct.fluids.fluids.PotionFluidAttributes;
import slimeknights.tconstruct.fluids.fluids.SlimeFluid;
import slimeknights.tconstruct.fluids.item.BottleItem;
import slimeknights.tconstruct.fluids.item.ContainerFoodItem;
import slimeknights.tconstruct.fluids.item.PotionBucketItem;
import slimeknights.tconstruct.fluids.util.BottleBrewingRecipe;
import slimeknights.tconstruct.fluids.util.EmptyBottleIntoEmpty;
import slimeknights.tconstruct.fluids.util.EmptyBottleIntoWater;
import slimeknights.tconstruct.fluids.util.FillBottle;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.network.FluidDataSerializer;
import slimeknights.tconstruct.world.TinkerWorld;

public final class TinkerFluids
extends TinkerModule {
    public static final FluidObject<ForgeFlowingFluid> blood = FLUIDS.register("blood", TinkerFluids.coolBuilder().density(1200).viscosity(1200).temperature(336), Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> venom = FLUIDS.register("venom", TinkerFluids.coolBuilder().density(1400).viscosity(1300).temperature(310), Material.f_76305_, 0);
    public static final ItemObject<Item> venomBottle = ITEMS.register("venom_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19600_, 1800), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19614_, 450), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)venom.get(), 250)));
    public static final RegistryObject<UnplaceableFluid> powderedSnow = FLUIDS.registerFluid("powdered_snow", () -> new UnplaceableFluid((Supplier)Items.f_151055_.delegate, FluidAttributes.builder((ResourceLocation)TConstruct.getResource("block/fluid/powdered_snow/still"), (ResourceLocation)TConstruct.getResource("block/fluid/powdered_snow/flowing")).sound(SoundEvents.f_11781_, SoundEvents.f_11778_).temperature(270)));
    public static final FluidObject<ForgeFlowingFluid> earthSlime = FLUIDS.register("earth_slime", "slime", TinkerFluids.coolBuilder().density(1400).viscosity(1400).temperature(350), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> skySlime = FLUIDS.register("sky_slime", TinkerFluids.coolBuilder().density(1500).viscosity(1500).temperature(310), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> enderSlime = FLUIDS.register("ender_slime", TinkerFluids.coolBuilder().density(1600).viscosity(1600).temperature(370), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 0);
    public static final FluidObject<ForgeFlowingFluid> magma = FLUIDS.register("magma", TinkerFluids.coolBuilder().density(1900).viscosity(1900).temperature(600), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.f_76305_, 3);
    public static final Map<SlimeType, FluidObject<ForgeFlowingFluid>> slime = new EnumMap<SlimeType, FluidObject<ForgeFlowingFluid>>(SlimeType.class);
    public static final EnumObject<SlimeType, Item> slimeBottle;
    public static final ItemObject<Item> magmaBottle;
    public static FluidObject<ForgeFlowingFluid> honey;
    public static FluidObject<ForgeFlowingFluid> beetrootSoup;
    public static FluidObject<ForgeFlowingFluid> mushroomStew;
    public static FluidObject<ForgeFlowingFluid> rabbitStew;
    public static final ItemObject<PotionBucketItem> potionBucket;
    public static final RegistryObject<UnplaceableFluid> potion;
    public static final ItemObject<Item> splashBottle;
    public static final ItemObject<Item> lingeringBottle;
    public static final FluidObject<ForgeFlowingFluid> searedStone;
    public static final FluidObject<ForgeFlowingFluid> scorchedStone;
    public static final FluidObject<ForgeFlowingFluid> moltenClay;
    public static final FluidObject<ForgeFlowingFluid> moltenGlass;
    public static final FluidObject<ForgeFlowingFluid> liquidSoul;
    public static final FluidObject<ForgeFlowingFluid> moltenPorcelain;
    public static final FluidObject<ForgeFlowingFluid> moltenObsidian;
    public static final FluidObject<ForgeFlowingFluid> moltenEnder;
    public static final FluidObject<ForgeFlowingFluid> blazingBlood;
    public static final FluidObject<ForgeFlowingFluid> moltenEmerald;
    public static final FluidObject<ForgeFlowingFluid> moltenQuartz;
    public static final FluidObject<ForgeFlowingFluid> moltenAmethyst;
    public static final FluidObject<ForgeFlowingFluid> moltenDiamond;
    public static final FluidObject<ForgeFlowingFluid> moltenDebris;
    public static final FluidObject<ForgeFlowingFluid> moltenIron;
    public static final FluidObject<ForgeFlowingFluid> moltenGold;
    public static final FluidObject<ForgeFlowingFluid> moltenCopper;
    public static final FluidObject<ForgeFlowingFluid> moltenCobalt;
    public static final FluidObject<ForgeFlowingFluid> moltenSlimesteel;
    public static final FluidObject<ForgeFlowingFluid> moltenAmethystBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenRoseGold;
    public static final FluidObject<ForgeFlowingFluid> moltenPigIron;
    public static final FluidObject<ForgeFlowingFluid> moltenManyullyn;
    public static final FluidObject<ForgeFlowingFluid> moltenHepatizon;
    public static final FluidObject<ForgeFlowingFluid> moltenQueensSlime;
    public static final FluidObject<ForgeFlowingFluid> moltenSoulsteel;
    public static final FluidObject<ForgeFlowingFluid> moltenNetherite;
    public static final FluidObject<ForgeFlowingFluid> moltenKnightslime;
    public static final FluidObject<ForgeFlowingFluid> moltenTin;
    public static final FluidObject<ForgeFlowingFluid> moltenAluminum;
    public static final FluidObject<ForgeFlowingFluid> moltenLead;
    public static final FluidObject<ForgeFlowingFluid> moltenSilver;
    public static final FluidObject<ForgeFlowingFluid> moltenNickel;
    public static final FluidObject<ForgeFlowingFluid> moltenZinc;
    public static final FluidObject<ForgeFlowingFluid> moltenPlatinum;
    public static final FluidObject<ForgeFlowingFluid> moltenTungsten;
    public static final FluidObject<ForgeFlowingFluid> moltenOsmium;
    public static final FluidObject<ForgeFlowingFluid> moltenUranium;
    public static final FluidObject<ForgeFlowingFluid> moltenBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenBrass;
    public static final FluidObject<ForgeFlowingFluid> moltenElectrum;
    public static final FluidObject<ForgeFlowingFluid> moltenInvar;
    public static final FluidObject<ForgeFlowingFluid> moltenConstantan;
    public static final FluidObject<ForgeFlowingFluid> moltenPewter;
    public static final FluidObject<ForgeFlowingFluid> moltenSteel;
    public static final FluidObject<ForgeFlowingFluid> moltenEnderium;
    public static final FluidObject<ForgeFlowingFluid> moltenLumium;
    public static final FluidObject<ForgeFlowingFluid> moltenSignalum;
    public static final FluidObject<ForgeFlowingFluid> moltenRefinedGlowstone;
    public static final FluidObject<ForgeFlowingFluid> moltenRefinedObsidian;
    public static final FluidDataSerializer FLUID_DATA_SERIALIZER;
    public static final RegistryObject<DataSerializerEntry> FLUID_DATA_SERIALIZER_REGISTRY;

    public TinkerFluids() {
        ForgeMod.enableMilkFluid();
    }

    private static FluidAttributes.Builder coolBuilder() {
        return ModelFluidAttributes.builder().sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
    }

    private static FluidAttributes.Builder hotBuilder() {
        return ModelFluidAttributes.builder().density(2000).viscosity(10000).temperature(1000).sound(SoundEvents.f_11783_, SoundEvents.f_11780_);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeClient()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.m_123914_((DataProvider)new FluidTooltipProvider(datagenerator));
        }
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CauldronInteraction.f_175607_.put((Item)splashBottle.get(), new FillBottle(Items.f_42736_));
            CauldronInteraction.f_175607_.put((Item)lingeringBottle.get(), new FillBottle(Items.f_42739_));
            CauldronInteraction.f_175607_.put(Items.f_42736_, new EmptyBottleIntoWater((Supplier<Item>)splashBottle, (CauldronInteraction)CauldronInteraction.f_175607_.get(Items.f_42736_)));
            CauldronInteraction.f_175607_.put(Items.f_42739_, new EmptyBottleIntoWater((Supplier<Item>)lingeringBottle, (CauldronInteraction)CauldronInteraction.f_175607_.get(Items.f_42739_)));
            CauldronInteraction.f_175606_.put(Items.f_42736_, new EmptyBottleIntoEmpty((Supplier<Item>)splashBottle, (CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42736_)));
            CauldronInteraction.f_175606_.put(Items.f_42739_, new EmptyBottleIntoEmpty((Supplier<Item>)lingeringBottle, (CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42739_)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Items.f_42589_, Items.f_42736_, new ItemStack(splashBottle)));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_204132_(TinkerTags.Items.SPLASH_BOTTLE), Items.f_42736_, Items.f_42739_, new ItemStack(lingeringBottle)));
        });
        DefaultDispenseItemBehavior dispenseBucket = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                DispensibleContainerItem container = (DispensibleContainerItem)stack.m_41720_();
                BlockPos blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = source.m_7727_();
                if (container.m_142073_(null, (Level)level, blockpos, null)) {
                    container.m_142131_(null, (Level)level, stack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
        };
        event.enqueueWork(() -> TinkerFluids.lambda$commonSetup$32((DispenseItemBehavior)dispenseBucket));
    }

    private static /* synthetic */ void lambda$commonSetup$32(DispenseItemBehavior dispenseBucket) {
        DispenserBlock.m_52672_(blood, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(venom, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(earthSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(skySlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(enderSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(magma, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(honey, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(beetrootSoup, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(mushroomStew, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(rabbitStew, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(searedStone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(scorchedStone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenClay, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenGlass, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(liquidSoul, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPorcelain, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenObsidian, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEnder, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(blazingBlood, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEmerald, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenQuartz, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAmethyst, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenDiamond, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenDebris, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenIron, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenGold, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenCopper, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenCobalt, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSlimesteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAmethystBronze, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRoseGold, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPigIron, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenManyullyn, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenHepatizon, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenQueensSlime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSoulsteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenNetherite, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenKnightslime, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenTin, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenAluminum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenLead, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSilver, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenNickel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenZinc, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPlatinum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenTungsten, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenOsmium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenUranium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenBronze, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenBrass, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenElectrum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenInvar, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenConstantan, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenPewter, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSteel, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenEnderium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenLumium, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenSignalum, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRefinedGlowstone, (DispenseItemBehavior)dispenseBucket);
        DispenserBlock.m_52672_(moltenRefinedObsidian, (DispenseItemBehavior)dispenseBucket);
        for (SlimeType slime : SlimeType.values()) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.congealedSlime.get((Enum)slime)}), new ItemStack((ItemLike)slimeBottle.get((Enum)slime))));
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50450_}), new ItemStack(magmaBottle)));
    }

    static {
        slime.put(SlimeType.EARTH, earthSlime);
        slime.put(SlimeType.SKY, skySlime);
        slime.put(SlimeType.ENDER, enderSlime);
        slime.put(SlimeType.BLOOD, blood);
        slimeBottle = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, (Supplier)ITEMS.register("earth_slime_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19621_, 1500), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19597_, 900), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)earthSlime.get(), 250)))).put((Enum)SlimeType.SKY, (Supplier)ITEMS.register("sky_slime_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19603_, 1800), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19597_, 900), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)skySlime.get(), 250)))).put((Enum)SlimeType.ENDER, (Supplier)ITEMS.register("ender_slime_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19620_, 450), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19597_, 900), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)enderSlime.get(), 250)))).put((Enum)SlimeType.ICHOR, (Supplier)ITEMS.register("ichor_bottle", () -> new ContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19617_, 500), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19597_, 900), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_)))).put((Enum)SlimeType.BLOOD, (Supplier)ITEMS.register("blood_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(0.1f).effect(() -> new MobEffectInstance(MobEffects.f_19599_, 600), 0.8f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(16).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)blood.get(), 250)))).build();
        magmaBottle = ITEMS.register("magma_bottle", () -> new ContainerFoodItem.FluidContainerFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19607_, 3600), 1.0f).m_38767_()).m_41491_(TAB_GENERAL).m_41487_(1).m_41495_(Items.f_42590_), () -> new FluidStack((Fluid)magma.get(), 250)));
        honey = FLUIDS.register("honey", TinkerFluids.coolBuilder().temperature(301), Material.f_76305_, 0);
        beetrootSoup = FLUIDS.register("beetroot_soup", TinkerFluids.coolBuilder().temperature(400), Material.f_76305_, 0);
        mushroomStew = FLUIDS.register("mushroom_stew", TinkerFluids.coolBuilder().temperature(400), Material.f_76305_, 0);
        rabbitStew = FLUIDS.register("rabbit_stew", TinkerFluids.coolBuilder().temperature(400), Material.f_76305_, 0);
        potionBucket = ITEMS.register("potion_bucket", () -> new PotionBucketItem((Supplier<? extends Fluid>)potion, ItemProperties.BUCKET_PROPS));
        potion = FLUIDS.registerFluid("potion", () -> new UnplaceableFluid(potionBucket, PotionFluidAttributes.builder(TConstruct.getResource("block/fluid/potion/")).sound(SoundEvents.f_11781_, SoundEvents.f_11778_).density(1100).viscosity(1100).temperature(315)));
        splashBottle = ITEMS.register("splash_bottle", () -> new BottleItem((ItemLike)Items.f_42736_, GENERAL_PROPS));
        lingeringBottle = ITEMS.register("lingering_bottle", () -> new BottleItem((ItemLike)Items.f_42739_, GENERAL_PROPS));
        searedStone = FLUIDS.register("seared_stone", TinkerFluids.hotBuilder().temperature(900), Material.f_76307_, 6);
        scorchedStone = FLUIDS.register("scorched_stone", TinkerFluids.hotBuilder().temperature(800), Material.f_76307_, 4);
        moltenClay = FLUIDS.register("molten_clay", TinkerFluids.hotBuilder().temperature(750), Material.f_76307_, 3);
        moltenGlass = FLUIDS.register("molten_glass", TinkerFluids.hotBuilder().temperature(1050), Material.f_76307_, 1);
        liquidSoul = FLUIDS.register("liquid_soul", TinkerFluids.hotBuilder().temperature(700), Material.f_76307_, 2);
        moltenPorcelain = FLUIDS.register("molten_porcelain", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 2);
        moltenObsidian = FLUIDS.register("molten_obsidian", TinkerFluids.hotBuilder().temperature(1300), Material.f_76307_, 3);
        moltenEnder = FLUIDS.register("molten_ender", "ender", TinkerFluids.hotBuilder().temperature(777), Material.f_76307_, 5);
        blazingBlood = FLUIDS.register("blazing_blood", TinkerFluids.hotBuilder().temperature(1800).density(3500), Material.f_76307_, 15);
        moltenEmerald = FLUIDS.register("molten_emerald", TinkerFluids.hotBuilder().temperature(1234), Material.f_76307_, 9);
        moltenQuartz = FLUIDS.register("molten_quartz", TinkerFluids.hotBuilder().temperature(937), Material.f_76307_, 6);
        moltenAmethyst = FLUIDS.register("molten_amethyst", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 11);
        moltenDiamond = FLUIDS.register("molten_diamond", TinkerFluids.hotBuilder().temperature(1750), Material.f_76307_, 13);
        moltenDebris = FLUIDS.register("molten_debris", TinkerFluids.hotBuilder().temperature(1475), Material.f_76307_, 14);
        moltenIron = FLUIDS.register("molten_iron", TinkerFluids.hotBuilder().temperature(1100), Material.f_76307_, 12);
        moltenGold = FLUIDS.register("molten_gold", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 12);
        moltenCopper = FLUIDS.register("molten_copper", TinkerFluids.hotBuilder().temperature(800), Material.f_76307_, 12);
        moltenCobalt = FLUIDS.register("molten_cobalt", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 8);
        moltenSlimesteel = FLUIDS.register("molten_slimesteel", TinkerFluids.hotBuilder().temperature(1200), Material.f_76307_, 10);
        moltenAmethystBronze = FLUIDS.register("molten_amethyst_bronze", TinkerFluids.hotBuilder().temperature(1120), Material.f_76307_, 12);
        moltenRoseGold = FLUIDS.register("molten_rose_gold", TinkerFluids.hotBuilder().temperature(850), Material.f_76307_, 12);
        moltenPigIron = FLUIDS.register("molten_pig_iron", TinkerFluids.hotBuilder().temperature(1111), Material.f_76307_, 10);
        moltenManyullyn = FLUIDS.register("molten_manyullyn", TinkerFluids.hotBuilder().temperature(1500), Material.f_76307_, 11);
        moltenHepatizon = FLUIDS.register("molten_hepatizon", TinkerFluids.hotBuilder().temperature(1700), Material.f_76307_, 8);
        moltenQueensSlime = FLUIDS.register("molten_queens_slime", TinkerFluids.hotBuilder().temperature(1450), Material.f_76307_, 9);
        moltenSoulsteel = FLUIDS.register("molten_soulsteel", TinkerFluids.hotBuilder().temperature(1500), Material.f_76307_, 6);
        moltenNetherite = FLUIDS.register("molten_netherite", TinkerFluids.hotBuilder().temperature(1550), Material.f_76307_, 14);
        moltenKnightslime = FLUIDS.register("molten_knightslime", TinkerFluids.hotBuilder().temperature(1425), Material.f_76307_, 12);
        moltenTin = FLUIDS.register("molten_tin", TinkerFluids.hotBuilder().temperature(525), Material.f_76307_, 12);
        moltenAluminum = FLUIDS.register("molten_aluminum", TinkerFluids.hotBuilder().temperature(725), Material.f_76307_, 12);
        moltenLead = FLUIDS.register("molten_lead", TinkerFluids.hotBuilder().temperature(630), Material.f_76307_, 12);
        moltenSilver = FLUIDS.register("molten_silver", TinkerFluids.hotBuilder().temperature(1090), Material.f_76307_, 12);
        moltenNickel = FLUIDS.register("molten_nickel", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 12);
        moltenZinc = FLUIDS.register("molten_zinc", TinkerFluids.hotBuilder().temperature(720), Material.f_76307_, 12);
        moltenPlatinum = FLUIDS.register("molten_platinum", TinkerFluids.hotBuilder().temperature(1270), Material.f_76307_, 12);
        moltenTungsten = FLUIDS.register("molten_tungsten", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 12);
        moltenOsmium = FLUIDS.register("molten_osmium", TinkerFluids.hotBuilder().temperature(1275), Material.f_76307_, 4);
        moltenUranium = FLUIDS.register("molten_uranium", TinkerFluids.hotBuilder().temperature(1130), Material.f_76307_, 15);
        moltenBronze = FLUIDS.register("molten_bronze", TinkerFluids.hotBuilder().temperature(1000), Material.f_76307_, 10);
        moltenBrass = FLUIDS.register("molten_brass", TinkerFluids.hotBuilder().temperature(905), Material.f_76307_, 10);
        moltenElectrum = FLUIDS.register("molten_electrum", TinkerFluids.hotBuilder().temperature(1060), Material.f_76307_, 10);
        moltenInvar = FLUIDS.register("molten_invar", TinkerFluids.hotBuilder().temperature(1200), Material.f_76307_, 10);
        moltenConstantan = FLUIDS.register("molten_constantan", TinkerFluids.hotBuilder().temperature(1220), Material.f_76307_, 10);
        moltenPewter = FLUIDS.register("molten_pewter", TinkerFluids.hotBuilder().temperature(700), Material.f_76307_, 10);
        moltenSteel = FLUIDS.register("molten_steel", TinkerFluids.hotBuilder().temperature(1250), Material.f_76307_, 13);
        moltenEnderium = FLUIDS.register("molten_enderium", TinkerFluids.hotBuilder().temperature(1650), Material.f_76307_, 12);
        moltenLumium = FLUIDS.register("molten_lumium", TinkerFluids.hotBuilder().temperature(1350), Material.f_76307_, 15);
        moltenSignalum = FLUIDS.register("molten_signalum", TinkerFluids.hotBuilder().temperature(1425), Material.f_76307_, 13);
        moltenRefinedGlowstone = FLUIDS.register("molten_refined_glowstone", TinkerFluids.hotBuilder().temperature(1125), Material.f_76307_, 15);
        moltenRefinedObsidian = FLUIDS.register("molten_refined_obsidian", TinkerFluids.hotBuilder().temperature(1775), Material.f_76307_, 7);
        FLUID_DATA_SERIALIZER = new FluidDataSerializer();
        FLUID_DATA_SERIALIZER_REGISTRY = DATA_SERIALIZERS.register("fluid", () -> new DataSerializerEntry((EntityDataSerializer)FLUID_DATA_SERIALIZER));
    }
}

